package zio.aws.clouddirectory.model
import java.lang.Integer
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAppliedSchemaArnsRequest(
    directoryArn: Arn,
    schemaArn: Option[Arn] = None,
    nextToken: Option[NextToken] = None,
    maxResults: Option[NumberResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest = {
    import ListAppliedSchemaArnsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest
      .wrap(buildAwsValue())
}
object ListAppliedSchemaArnsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest =
      zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest(
        directoryArn,
        schemaArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def directoryArn: Arn
    def schemaArn: Option[Arn]
    def nextToken: Option[NextToken]
    def maxResults: Option[NumberResults]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest
  ) extends zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Option[NumberResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest
  ): zio.aws.clouddirectory.model.ListAppliedSchemaArnsRequest.ReadOnly =
    new Wrapper(impl)
}
