package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetObjectInformationRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest = {
    import GetObjectInformationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetObjectInformationRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetObjectInformationRequest
      .wrap(buildAwsValue())
}
object GetObjectInformationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetObjectInformationRequest =
      zio.aws.clouddirectory.model.GetObjectInformationRequest(
        directoryArn,
        objectReference.asEditable,
        consistencyLevel.map(value => value)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def consistencyLevel: Option[zio.aws.clouddirectory.model.ConsistencyLevel]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest
  ) extends zio.aws.clouddirectory.model.GetObjectInformationRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val consistencyLevel
        : Option[zio.aws.clouddirectory.model.ConsistencyLevel] = scala
      .Option(impl.consistencyLevel())
      .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest
  ): zio.aws.clouddirectory.model.GetObjectInformationRequest.ReadOnly =
    new Wrapper(impl)
}
