package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class FacetAttribute(
    name: AttributeName,
    attributeDefinition: Option[
      zio.aws.clouddirectory.model.FacetAttributeDefinition
    ] = None,
    attributeReference: Option[
      zio.aws.clouddirectory.model.FacetAttributeReference
    ] = None,
    requiredBehavior: Option[
      zio.aws.clouddirectory.model.RequiredAttributeBehavior
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.FacetAttribute = {
    import FacetAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.FacetAttribute
      .builder()
      .name(AttributeName.unwrap(name): java.lang.String)
      .optionallyWith(attributeDefinition.map(value => value.buildAwsValue()))(
        _.attributeDefinition
      )
      .optionallyWith(attributeReference.map(value => value.buildAwsValue()))(
        _.attributeReference
      )
      .optionallyWith(requiredBehavior.map(value => value.unwrap))(
        _.requiredBehavior
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.FacetAttribute.ReadOnly =
    zio.aws.clouddirectory.model.FacetAttribute.wrap(buildAwsValue())
}
object FacetAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.FacetAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.FacetAttribute =
      zio.aws.clouddirectory.model.FacetAttribute(
        name,
        attributeDefinition.map(value => value.asEditable),
        attributeReference.map(value => value.asEditable),
        requiredBehavior.map(value => value)
      )
    def name: AttributeName
    def attributeDefinition
        : Option[zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly]
    def attributeReference
        : Option[zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly]
    def requiredBehavior
        : Option[zio.aws.clouddirectory.model.RequiredAttributeBehavior]
    def getName: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(name)
    def getAttributeDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly
    ] = AwsError.unwrapOptionField("attributeDefinition", attributeDefinition)
    def getAttributeReference: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly
    ] = AwsError.unwrapOptionField("attributeReference", attributeReference)
    def getRequiredBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.RequiredAttributeBehavior
    ] = AwsError.unwrapOptionField("requiredBehavior", requiredBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttribute
  ) extends zio.aws.clouddirectory.model.FacetAttribute.ReadOnly {
    override val name: AttributeName =
      zio.aws.clouddirectory.model.primitives.AttributeName(impl.name())
    override val attributeDefinition: Option[
      zio.aws.clouddirectory.model.FacetAttributeDefinition.ReadOnly
    ] = scala
      .Option(impl.attributeDefinition())
      .map(value =>
        zio.aws.clouddirectory.model.FacetAttributeDefinition.wrap(value)
      )
    override val attributeReference: Option[
      zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly
    ] = scala
      .Option(impl.attributeReference())
      .map(value =>
        zio.aws.clouddirectory.model.FacetAttributeReference.wrap(value)
      )
    override val requiredBehavior
        : Option[zio.aws.clouddirectory.model.RequiredAttributeBehavior] = scala
      .Option(impl.requiredBehavior())
      .map(value =>
        zio.aws.clouddirectory.model.RequiredAttributeBehavior.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttribute
  ): zio.aws.clouddirectory.model.FacetAttribute.ReadOnly = new Wrapper(impl)
}
