package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteSchemaResponse(schemaArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse = {
    import DeleteSchemaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly =
    zio.aws.clouddirectory.model.DeleteSchemaResponse.wrap(buildAwsValue())
}
object DeleteSchemaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteSchemaResponse =
      zio.aws.clouddirectory.model
        .DeleteSchemaResponse(schemaArn.map(value => value))
    def schemaArn: Option[Arn]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse
  ) extends zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly {
    override val schemaArn: Option[Arn] = scala
      .Option(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaResponse
  ): zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly = new Wrapper(
    impl
  )
}
