package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BatchListIndexResponse(
    indexAttachments: Option[
      Iterable[zio.aws.clouddirectory.model.IndexAttachment]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse = {
    import BatchListIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse
      .builder()
      .optionallyWith(
        indexAttachments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.indexAttachments)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListIndexResponse.wrap(buildAwsValue())
}
object BatchListIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListIndexResponse =
      zio.aws.clouddirectory.model.BatchListIndexResponse(
        indexAttachments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def indexAttachments
        : Option[List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]]
    def nextToken: Option[NextToken]
    def getIndexAttachments: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("indexAttachments", indexAttachments)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse
  ) extends zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly {
    override val indexAttachments
        : Option[List[zio.aws.clouddirectory.model.IndexAttachment.ReadOnly]] =
      scala
        .Option(impl.indexAttachments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.IndexAttachment.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListIndexResponse
  ): zio.aws.clouddirectory.model.BatchListIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
