package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AddFacetToObjectRequest(
    directoryArn: Arn,
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    objectAttributeList: Option[
      Iterable[zio.aws.clouddirectory.model.AttributeKeyAndValue]
    ] = None,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest = {
    import AddFacetToObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .schemaFacet(schemaFacet.buildAwsValue())
      .optionallyWith(
        objectAttributeList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.objectAttributeList)
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.AddFacetToObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.AddFacetToObjectRequest.wrap(buildAwsValue())
}
object AddFacetToObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AddFacetToObjectRequest =
      zio.aws.clouddirectory.model.AddFacetToObjectRequest(
        directoryArn,
        schemaFacet.asEditable,
        objectAttributeList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        objectReference.asEditable
      )
    def directoryArn: Arn
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def objectAttributeList: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ]
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getObjectAttributeList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = AwsError.unwrapOptionField("objectAttributeList", objectAttributeList)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest
  ) extends zio.aws.clouddirectory.model.AddFacetToObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val objectAttributeList: Option[
      List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    ] = scala
      .Option(impl.objectAttributeList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }.toList
      )
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest
  ): zio.aws.clouddirectory.model.AddFacetToObjectRequest.ReadOnly =
    new Wrapper(impl)
}
