package zio.aws.clouddirectory
import zio.aws.clouddirectory.model.DetachPolicyResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.clouddirectory.model.{
  BatchWriteRequest,
  ListTypedLinkFacetNamesRequest,
  UpdateFacetRequest,
  AttachTypedLinkRequest,
  ListObjectAttributesRequest,
  AttachToIndexRequest,
  GetAppliedSchemaVersionRequest,
  GetObjectInformationRequest,
  GetDirectoryRequest,
  GetSchemaAsJsonRequest,
  ListManagedSchemaArnsRequest,
  DisableDirectoryRequest,
  CreateFacetRequest,
  ListObjectParentPathsRequest,
  CreateIndexRequest,
  DetachObjectRequest,
  LookupPolicyRequest,
  BatchReadRequest,
  ListPolicyAttachmentsRequest,
  UpdateTypedLinkFacetRequest,
  ListTagsForResourceRequest,
  CreateSchemaRequest,
  GetTypedLinkFacetInformationRequest,
  ListIndexRequest,
  UpgradeAppliedSchemaRequest,
  ListIncomingTypedLinksRequest,
  ListOutgoingTypedLinksRequest,
  UpdateObjectAttributesRequest,
  CreateDirectoryRequest,
  AddFacetToObjectRequest,
  DeleteTypedLinkFacetRequest,
  GetLinkAttributesRequest,
  ListAttachedIndicesRequest,
  ListObjectChildrenRequest,
  DeleteDirectoryRequest,
  ListObjectPoliciesRequest,
  ListPublishedSchemaArnsRequest,
  EnableDirectoryRequest,
  UpdateSchemaRequest,
  DetachTypedLinkRequest,
  CreateTypedLinkFacetRequest,
  UpgradePublishedSchemaRequest,
  PutSchemaFromJsonRequest,
  RemoveFacetFromObjectRequest,
  DetachFromIndexRequest,
  UpdateLinkAttributesRequest,
  DetachPolicyRequest,
  UntagResourceRequest,
  DeleteFacetRequest,
  ListFacetNamesRequest,
  ListDevelopmentSchemaArnsRequest,
  ListAppliedSchemaArnsRequest,
  PublishSchemaRequest,
  AttachObjectRequest,
  ListTypedLinkFacetAttributesRequest,
  ApplySchemaRequest,
  DeleteSchemaRequest,
  DeleteObjectRequest,
  CreateObjectRequest,
  ListDirectoriesRequest,
  GetObjectAttributesRequest,
  ListObjectParentsRequest,
  TagResourceRequest,
  AttachPolicyRequest,
  GetFacetRequest,
  ListFacetAttributesRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.clouddirectory.{
  CloudDirectoryAsyncClientBuilder,
  CloudDirectoryAsyncClient
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.clouddirectory.model.{
  UpgradePublishedSchemaResponse,
  TypedLinkAttributeDefinition,
  DetachObjectResponse,
  ListAttachedIndicesResponse,
  PathToObjectIdentifiers,
  ListObjectParentsResponse,
  LookupPolicyResponse,
  GetSchemaAsJsonResponse,
  CreateSchemaResponse,
  IndexAttachment,
  GetFacetResponse,
  ListDevelopmentSchemaArnsResponse,
  ListTypedLinkFacetNamesResponse,
  PutSchemaFromJsonResponse,
  CreateTypedLinkFacetResponse,
  DisableDirectoryResponse,
  DetachTypedLinkResponse,
  DeleteDirectoryResponse,
  ListTypedLinkFacetAttributesResponse,
  DetachFromIndexResponse,
  AttachObjectResponse,
  PublishSchemaResponse,
  UpdateLinkAttributesResponse,
  DeleteFacetResponse,
  GetDirectoryResponse,
  GetObjectInformationResponse,
  Tag,
  DeleteObjectResponse,
  CreateDirectoryResponse,
  ListAppliedSchemaArnsResponse,
  ListFacetAttributesResponse,
  UpgradeAppliedSchemaResponse,
  CreateIndexResponse,
  FacetAttribute,
  RemoveFacetFromObjectResponse,
  DeleteTypedLinkFacetResponse,
  UpdateTypedLinkFacetResponse,
  BatchReadResponse,
  ListPolicyAttachmentsResponse,
  ListDirectoriesResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateObjectResponse,
  ListPublishedSchemaArnsResponse,
  GetLinkAttributesResponse,
  DetachPolicyResponse,
  GetTypedLinkFacetInformationResponse,
  AttachPolicyResponse,
  AttachTypedLinkResponse,
  CreateFacetResponse,
  ListIncomingTypedLinksResponse,
  BatchWriteResponse,
  DeleteSchemaResponse,
  ListIndexResponse,
  ListOutgoingTypedLinksResponse,
  ListObjectParentPathsResponse,
  ListObjectPoliciesResponse,
  AddFacetToObjectResponse,
  ListObjectAttributesResponse,
  ListManagedSchemaArnsResponse,
  ListFacetNamesResponse,
  PolicyToPath,
  GetObjectAttributesResponse,
  UpdateObjectAttributesResponse,
  UpdateSchemaResponse,
  ListObjectChildrenResponse,
  ObjectIdentifierAndLinkNameTuple,
  GetAppliedSchemaVersionResponse,
  TagResourceResponse,
  Directory,
  EnableDirectoryResponse,
  AttributeKeyAndValue,
  AttachToIndexResponse,
  TypedLinkSpecifier,
  ApplySchemaResponse,
  UpdateFacetResponse
}
import zio.stream.ZStream
import zio.aws.clouddirectory.model.primitives.{
  LinkName,
  Arn,
  TypedLinkName,
  FacetName,
  ObjectIdentifier
}
import scala.jdk.CollectionConverters.*
trait CloudDirectory extends AspectSupport[CloudDirectory] {
  val api: CloudDirectoryAsyncClient
  def listObjectParentPaths(request: ListObjectParentPathsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
  ]
  def listObjectParentPathsPaginated(request: ListObjectParentPathsRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly
  ]
  def listDirectories(
      request: ListDirectoriesRequest
  ): ZStream[Any, AwsError, zio.aws.clouddirectory.model.Directory.ReadOnly]
  def listDirectoriesPaginated(
      request: ListDirectoriesRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly]
  def listAttachedIndices(request: ListAttachedIndicesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
  ]
  def listAttachedIndicesPaginated(request: ListAttachedIndicesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListAttachedIndicesResponse.ReadOnly
  ]
  def attachToIndex(
      request: AttachToIndexRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly]
  def listObjectAttributes(request: ListObjectAttributesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
  ]
  def listObjectAttributesPaginated(request: ListObjectAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly
  ]
  def batchWrite(
      request: BatchWriteRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly]
  def deleteFacet(
      request: DeleteFacetRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DeleteFacetResponse.ReadOnly]
  def attachTypedLink(
      request: AttachTypedLinkRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly]
  def listFacetAttributes(request: ListFacetAttributesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
  ]
  def listFacetAttributesPaginated(request: ListFacetAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly
  ]
  def lookupPolicy(
      request: LookupPolicyRequest
  ): ZStream[Any, AwsError, zio.aws.clouddirectory.model.PolicyToPath.ReadOnly]
  def lookupPolicyPaginated(
      request: LookupPolicyRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly]
  def attachObject(
      request: AttachObjectRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly]
  def listObjectParents(
      request: ListObjectParentsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly,
    zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
  ]]
  def listObjectParentsPaginated(request: ListObjectParentsRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly
  ]
  def getAppliedSchemaVersion(request: GetAppliedSchemaVersionRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly
  ]
  def updateLinkAttributes(request: UpdateLinkAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.ReadOnly
  ]
  def getObjectAttributes(request: GetObjectAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly
  ]
  def upgradePublishedSchema(request: UpgradePublishedSchemaRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly
  ]
  def putSchemaFromJson(request: PutSchemaFromJsonRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly
  ]
  def listManagedSchemaArns(
      request: ListManagedSchemaArnsRequest
  ): ZStream[Any, AwsError, Arn]
  def listManagedSchemaArnsPaginated(request: ListManagedSchemaArnsRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.ReadOnly
  ]
  def enableDirectory(
      request: EnableDirectoryRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly]
  def detachPolicy(request: DetachPolicyRequest): IO[AwsError, ReadOnly]
  def updateTypedLinkFacet(request: UpdateTypedLinkFacetRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.ReadOnly
  ]
  def deleteTypedLinkFacet(request: DeleteTypedLinkFacetRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.ReadOnly
  ]
  def upgradeAppliedSchema(request: UpgradeAppliedSchemaRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly
  ]
  def deleteObject(
      request: DeleteObjectRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DeleteObjectResponse.ReadOnly]
  def createTypedLinkFacet(request: CreateTypedLinkFacetRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.ReadOnly
  ]
  def updateFacet(
      request: UpdateFacetRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.UpdateFacetResponse.ReadOnly]
  def listObjectPolicies(
      request: ListObjectPoliciesRequest
  ): ZStream[Any, AwsError, ObjectIdentifier]
  def listObjectPoliciesPaginated(request: ListObjectPoliciesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly
  ]
  def listTypedLinkFacetNames(
      request: ListTypedLinkFacetNamesRequest
  ): ZStream[Any, AwsError, TypedLinkName]
  def listTypedLinkFacetNamesPaginated(
      request: ListTypedLinkFacetNamesRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly
  ]
  def removeFacetFromObject(request: RemoveFacetFromObjectRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.ReadOnly
  ]
  def disableDirectory(request: DisableDirectoryRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly
  ]
  def getFacet(
      request: GetFacetRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly]
  def createObject(
      request: CreateObjectRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly]
  def updateSchema(
      request: UpdateSchemaRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.UpdateSchemaResponse.ReadOnly]
  def getSchemaAsJson(
      request: GetSchemaAsJsonRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly]
  def createFacet(
      request: CreateFacetRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.CreateFacetResponse.ReadOnly]
  def detachTypedLink(request: DetachTypedLinkRequest): IO[AwsError, Unit]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.UntagResourceResponse.ReadOnly]
  def listObjectChildren(
      request: ListObjectChildrenRequest
  ): ZStream[Any, AwsError, Tuple2[LinkName, ObjectIdentifier]]
  def listObjectChildrenPaginated(request: ListObjectChildrenRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly
  ]
  def applySchema(
      request: ApplySchemaRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly]
  def listFacetNames(
      request: ListFacetNamesRequest
  ): ZStream[Any, AwsError, FacetName]
  def listFacetNamesPaginated(
      request: ListFacetNamesRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly]
  def listTypedLinkFacetAttributes(
      request: ListTypedLinkFacetAttributesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
  ]
  def listTypedLinkFacetAttributesPaginated(
      request: ListTypedLinkFacetAttributesRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly
  ]
  def attachPolicy(
      request: AttachPolicyRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.AttachPolicyResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.clouddirectory.model.Tag.ReadOnly]
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly
  ]
  def updateObjectAttributes(request: UpdateObjectAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.ReadOnly
  ]
  def addFacetToObject(request: AddFacetToObjectRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.AddFacetToObjectResponse.ReadOnly
  ]
  def getTypedLinkFacetInformation(
      request: GetTypedLinkFacetInformationRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.TagResourceResponse.ReadOnly]
  def createDirectory(
      request: CreateDirectoryRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly]
  def getLinkAttributes(request: GetLinkAttributesRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly
  ]
  def createSchema(
      request: CreateSchemaRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly]
  def getObjectInformation(request: GetObjectInformationRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.GetObjectInformationResponse.ReadOnly
  ]
  def listIndex(request: ListIndexRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
  ]
  def listIndexPaginated(
      request: ListIndexRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly]
  def detachFromIndex(
      request: DetachFromIndexRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly]
  def publishSchema(
      request: PublishSchemaRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly]
  def deleteSchema(
      request: DeleteSchemaRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly]
  def listOutgoingTypedLinks(request: ListOutgoingTypedLinksRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
  ]
  def listOutgoingTypedLinksPaginated(
      request: ListOutgoingTypedLinksRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly
  ]
  def getDirectory(
      request: GetDirectoryRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly]
  def listPublishedSchemaArns(
      request: ListPublishedSchemaArnsRequest
  ): ZStream[Any, AwsError, Arn]
  def listPublishedSchemaArnsPaginated(
      request: ListPublishedSchemaArnsRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly
  ]
  def listPolicyAttachments(
      request: ListPolicyAttachmentsRequest
  ): ZStream[Any, AwsError, ObjectIdentifier]
  def listPolicyAttachmentsPaginated(request: ListPolicyAttachmentsRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly
  ]
  def deleteDirectory(
      request: DeleteDirectoryRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly]
  def detachObject(
      request: DetachObjectRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly]
  def batchRead(
      request: BatchReadRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly]
  def listIncomingTypedLinks(request: ListIncomingTypedLinksRequest): ZStream[
    Any,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
  ]
  def listIncomingTypedLinksPaginated(
      request: ListIncomingTypedLinksRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly
  ]
  def listDevelopmentSchemaArns(
      request: ListDevelopmentSchemaArnsRequest
  ): ZStream[Any, AwsError, Arn]
  def listDevelopmentSchemaArnsPaginated(
      request: ListDevelopmentSchemaArnsRequest
  ): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly
  ]
  def createIndex(
      request: CreateIndexRequest
  ): IO[AwsError, zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly]
  def listAppliedSchemaArns(
      request: ListAppliedSchemaArnsRequest
  ): ZStream[Any, AwsError, Arn]
  def listAppliedSchemaArnsPaginated(request: ListAppliedSchemaArnsRequest): IO[
    AwsError,
    zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly
  ]
}
object CloudDirectory {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CloudDirectory] = customized(
    identity
  )
  def customized(
      customization: CloudDirectoryAsyncClientBuilder => CloudDirectoryAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CloudDirectory] = managed(
    customization
  ).toLayer
  def managed(
      customization: CloudDirectoryAsyncClientBuilder => CloudDirectoryAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CloudDirectory] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CloudDirectoryAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CloudDirectoryAsyncClient, CloudDirectoryAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        CloudDirectoryAsyncClient,
        CloudDirectoryAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new CloudDirectoryImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class CloudDirectoryImpl[R](
      override val api: CloudDirectoryAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CloudDirectory
      with AwsServiceBase[R] {
    override val serviceName: String = "CloudDirectory"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CloudDirectoryImpl[R1] = new CloudDirectoryImpl(api, newAspect, r)
    def listObjectParentPaths(request: ListObjectParentPathsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest,
      ListObjectParentPathsResponse,
      PathToObjectIdentifiers
    ](
      "listObjectParentPaths",
      api.listObjectParentPaths,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pathToObjectIdentifiersList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.clouddirectory.model.PathToObjectIdentifiers.wrap(item)
      )
      .provideEnvironment(r)
    def listObjectParentPathsPaginated(
        request: ListObjectParentPathsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectParentPathsRequest,
      ListObjectParentPathsResponse
    ]("listObjectParentPaths", api.listObjectParentPaths)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListObjectParentPathsResponse.wrap)
      .provideEnvironment(r)
    def listDirectories(
        request: ListDirectoriesRequest
    ): ZStream[Any, AwsError, zio.aws.clouddirectory.model.Directory.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest,
        ListDirectoriesResponse,
        Directory
      ](
        "listDirectories",
        api.listDirectories,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.directories().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.clouddirectory.model.Directory.wrap(item))
        .provideEnvironment(r)
    def listDirectoriesPaginated(request: ListDirectoriesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest,
      ListDirectoriesResponse
    ]("listDirectories", api.listDirectories)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListDirectoriesResponse.wrap)
      .provideEnvironment(r)
    def listAttachedIndices(request: ListAttachedIndicesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest,
      ListAttachedIndicesResponse,
      IndexAttachment
    ](
      "listAttachedIndices",
      api.listAttachedIndices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.indexAttachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.IndexAttachment.wrap(item))
      .provideEnvironment(r)
    def listAttachedIndicesPaginated(request: ListAttachedIndicesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListAttachedIndicesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListAttachedIndicesRequest,
      ListAttachedIndicesResponse
    ]("listAttachedIndices", api.listAttachedIndices)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListAttachedIndicesResponse.wrap)
      .provideEnvironment(r)
    def attachToIndex(request: AttachToIndexRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.AttachToIndexRequest,
      AttachToIndexResponse
    ]("attachToIndex", api.attachToIndex)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.AttachToIndexResponse.wrap)
      .provideEnvironment(r)
    def listObjectAttributes(request: ListObjectAttributesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest,
      ListObjectAttributesResponse,
      AttributeKeyAndValue
    ](
      "listObjectAttributes",
      api.listObjectAttributes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attributes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item))
      .provideEnvironment(r)
    def listObjectAttributesPaginated(request: ListObjectAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectAttributesRequest,
      ListObjectAttributesResponse
    ]("listObjectAttributes", api.listObjectAttributes)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListObjectAttributesResponse.wrap)
      .provideEnvironment(r)
    def batchWrite(
        request: BatchWriteRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.BatchWriteRequest,
        BatchWriteResponse
      ]("batchWrite", api.batchWrite)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.BatchWriteResponse.wrap)
        .provideEnvironment(r)
    def deleteFacet(
        request: DeleteFacetRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.DeleteFacetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest,
        DeleteFacetResponse
      ]("deleteFacet", api.deleteFacet)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.DeleteFacetResponse.wrap)
        .provideEnvironment(r)
    def attachTypedLink(request: AttachTypedLinkRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.AttachTypedLinkRequest,
      AttachTypedLinkResponse
    ]("attachTypedLink", api.attachTypedLink)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.AttachTypedLinkResponse.wrap)
      .provideEnvironment(r)
    def listFacetAttributes(request: ListFacetAttributesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest,
      ListFacetAttributesResponse,
      FacetAttribute
    ](
      "listFacetAttributes",
      api.listFacetAttributes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attributes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.FacetAttribute.wrap(item))
      .provideEnvironment(r)
    def listFacetAttributesPaginated(request: ListFacetAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesRequest,
      ListFacetAttributesResponse
    ]("listFacetAttributes", api.listFacetAttributes)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListFacetAttributesResponse.wrap)
      .provideEnvironment(r)
    def lookupPolicy(request: LookupPolicyRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest,
      LookupPolicyResponse,
      PolicyToPath
    ](
      "lookupPolicy",
      api.lookupPolicy,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.policyToPathList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.PolicyToPath.wrap(item))
      .provideEnvironment(r)
    def lookupPolicyPaginated(request: LookupPolicyRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest,
      LookupPolicyResponse
    ]("lookupPolicy", api.lookupPolicy)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.LookupPolicyResponse.wrap)
      .provideEnvironment(r)
    def attachObject(request: AttachObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest,
      AttachObjectResponse
    ]("attachObject", api.attachObject)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.AttachObjectResponse.wrap)
      .provideEnvironment(r)
    def listObjectParents(
        request: ListObjectParentsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly,
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest,
      ListObjectParentsResponse,
      ObjectIdentifierAndLinkNameTuple
    ](
      "listObjectParents",
      api.listObjectParents,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.parentLinks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.clouddirectory.model.ListObjectParentsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listObjectParentsPaginated(request: ListObjectParentsRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest,
      ListObjectParentsResponse
    ]("listObjectParents", api.listObjectParents)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListObjectParentsResponse.wrap)
      .provideEnvironment(r)
    def getAppliedSchemaVersion(request: GetAppliedSchemaVersionRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest,
      GetAppliedSchemaVersionResponse
    ]("getAppliedSchemaVersion", api.getAppliedSchemaVersion)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.wrap)
      .provideEnvironment(r)
    def updateLinkAttributes(request: UpdateLinkAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpdateLinkAttributesRequest,
      UpdateLinkAttributesResponse
    ]("updateLinkAttributes", api.updateLinkAttributes)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.wrap)
      .provideEnvironment(r)
    def getObjectAttributes(request: GetObjectAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetObjectAttributesRequest,
      GetObjectAttributesResponse
    ]("getObjectAttributes", api.getObjectAttributes)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.GetObjectAttributesResponse.wrap)
      .provideEnvironment(r)
    def upgradePublishedSchema(request: UpgradePublishedSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpgradePublishedSchemaRequest,
      UpgradePublishedSchemaResponse
    ]("upgradePublishedSchema", api.upgradePublishedSchema)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.wrap)
      .provideEnvironment(r)
    def putSchemaFromJson(request: PutSchemaFromJsonRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.PutSchemaFromJsonRequest,
      PutSchemaFromJsonResponse
    ]("putSchemaFromJson", api.putSchemaFromJson)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.wrap)
      .provideEnvironment(r)
    def listManagedSchemaArns(
        request: ListManagedSchemaArnsRequest
    ): ZStream[Any, AwsError, Arn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest,
      ListManagedSchemaArnsResponse,
      java.lang.String
    ](
      "listManagedSchemaArns",
      api.listManagedSchemaArns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemaArns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.Arn(item))
      .provideEnvironment(r)
    def listManagedSchemaArnsPaginated(
        request: ListManagedSchemaArnsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest,
      ListManagedSchemaArnsResponse
    ]("listManagedSchemaArns", api.listManagedSchemaArns)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.wrap)
      .provideEnvironment(r)
    def enableDirectory(request: EnableDirectoryRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryRequest,
      EnableDirectoryResponse
    ]("enableDirectory", api.enableDirectory)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.EnableDirectoryResponse.wrap)
      .provideEnvironment(r)
    def detachPolicy(request: DetachPolicyRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.DetachPolicyRequest,
        DetachPolicyResponse
      ]("detachPolicy", api.detachPolicy)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.DetachPolicyResponse.wrap)
        .provideEnvironment(r)
    def updateTypedLinkFacet(request: UpdateTypedLinkFacetRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpdateTypedLinkFacetRequest,
      UpdateTypedLinkFacetResponse
    ]("updateTypedLinkFacet", api.updateTypedLinkFacet)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.wrap)
      .provideEnvironment(r)
    def deleteTypedLinkFacet(request: DeleteTypedLinkFacetRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DeleteTypedLinkFacetRequest,
      DeleteTypedLinkFacetResponse
    ]("deleteTypedLinkFacet", api.deleteTypedLinkFacet)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.wrap)
      .provideEnvironment(r)
    def upgradeAppliedSchema(request: UpgradeAppliedSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpgradeAppliedSchemaRequest,
      UpgradeAppliedSchemaResponse
    ]("upgradeAppliedSchema", api.upgradeAppliedSchema)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.wrap)
      .provideEnvironment(r)
    def deleteObject(request: DeleteObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DeleteObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DeleteObjectRequest,
      DeleteObjectResponse
    ]("deleteObject", api.deleteObject)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DeleteObjectResponse.wrap)
      .provideEnvironment(r)
    def createTypedLinkFacet(request: CreateTypedLinkFacetRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.CreateTypedLinkFacetRequest,
      CreateTypedLinkFacetResponse
    ]("createTypedLinkFacet", api.createTypedLinkFacet)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.wrap)
      .provideEnvironment(r)
    def updateFacet(
        request: UpdateFacetRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.UpdateFacetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.UpdateFacetRequest,
        UpdateFacetResponse
      ]("updateFacet", api.updateFacet)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.UpdateFacetResponse.wrap)
        .provideEnvironment(r)
    def listObjectPolicies(
        request: ListObjectPoliciesRequest
    ): ZStream[Any, AwsError, ObjectIdentifier] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest,
      ListObjectPoliciesResponse,
      java.lang.String
    ](
      "listObjectPolicies",
      api.listObjectPolicies,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attachedPolicyIds().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(item)
      )
      .provideEnvironment(r)
    def listObjectPoliciesPaginated(request: ListObjectPoliciesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesRequest,
      ListObjectPoliciesResponse
    ]("listObjectPolicies", api.listObjectPolicies)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListObjectPoliciesResponse.wrap)
      .provideEnvironment(r)
    def listTypedLinkFacetNames(
        request: ListTypedLinkFacetNamesRequest
    ): ZStream[Any, AwsError, TypedLinkName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest,
      ListTypedLinkFacetNamesResponse,
      java.lang.String
    ](
      "listTypedLinkFacetNames",
      api.listTypedLinkFacetNames,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.facetNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.TypedLinkName(item))
      .provideEnvironment(r)
    def listTypedLinkFacetNamesPaginated(
        request: ListTypedLinkFacetNamesRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesRequest,
      ListTypedLinkFacetNamesResponse
    ]("listTypedLinkFacetNames", api.listTypedLinkFacetNames)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.wrap)
      .provideEnvironment(r)
    def removeFacetFromObject(request: RemoveFacetFromObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest,
      RemoveFacetFromObjectResponse
    ]("removeFacetFromObject", api.removeFacetFromObject)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.wrap)
      .provideEnvironment(r)
    def disableDirectory(request: DisableDirectoryRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DisableDirectoryRequest,
      DisableDirectoryResponse
    ]("disableDirectory", api.disableDirectory)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DisableDirectoryResponse.wrap)
      .provideEnvironment(r)
    def getFacet(
        request: GetFacetRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.GetFacetRequest,
        GetFacetResponse
      ]("getFacet", api.getFacet)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.GetFacetResponse.wrap)
        .provideEnvironment(r)
    def createObject(request: CreateObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.CreateObjectRequest,
      CreateObjectResponse
    ]("createObject", api.createObject)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.CreateObjectResponse.wrap)
      .provideEnvironment(r)
    def updateSchema(request: UpdateSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpdateSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpdateSchemaRequest,
      UpdateSchemaResponse
    ]("updateSchema", api.updateSchema)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.UpdateSchemaResponse.wrap)
      .provideEnvironment(r)
    def getSchemaAsJson(request: GetSchemaAsJsonRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetSchemaAsJsonRequest,
      GetSchemaAsJsonResponse
    ]("getSchemaAsJson", api.getSchemaAsJson)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.wrap)
      .provideEnvironment(r)
    def createFacet(
        request: CreateFacetRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.CreateFacetResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.CreateFacetRequest,
        CreateFacetResponse
      ]("createFacet", api.createFacet)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.CreateFacetResponse.wrap)
        .provideEnvironment(r)
    def detachTypedLink(request: DetachTypedLinkRequest): IO[AwsError, Unit] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.DetachTypedLinkRequest,
        DetachTypedLinkResponse
      ]("detachTypedLink", api.detachTypedLink)(request.buildAwsValue()).unit
        .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listObjectChildren(
        request: ListObjectChildrenRequest
    ): ZStream[Any, AwsError, Tuple2[LinkName, ObjectIdentifier]] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest,
        ListObjectChildrenResponse,
        (java.lang.String, java.lang.String)
      ](
        "listObjectChildren",
        api.listObjectChildren,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.children().asScala)
      )(request.buildAwsValue())
        .map({ case (key, value) =>
          zio.aws.clouddirectory.model.primitives.LinkName(
            key
          ) -> zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        })
        .provideEnvironment(r)
    def listObjectChildrenPaginated(request: ListObjectChildrenRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListObjectChildrenRequest,
      ListObjectChildrenResponse
    ]("listObjectChildren", api.listObjectChildren)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListObjectChildrenResponse.wrap)
      .provideEnvironment(r)
    def applySchema(
        request: ApplySchemaRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest,
        ApplySchemaResponse
      ]("applySchema", api.applySchema)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.ApplySchemaResponse.wrap)
        .provideEnvironment(r)
    def listFacetNames(
        request: ListFacetNamesRequest
    ): ZStream[Any, AwsError, FacetName] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest,
      ListFacetNamesResponse,
      java.lang.String
    ](
      "listFacetNames",
      api.listFacetNames,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.facetNames().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.FacetName(item))
      .provideEnvironment(r)
    def listFacetNamesPaginated(request: ListFacetNamesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListFacetNamesRequest,
      ListFacetNamesResponse
    ]("listFacetNames", api.listFacetNames)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListFacetNamesResponse.wrap)
      .provideEnvironment(r)
    def listTypedLinkFacetAttributes(
        request: ListTypedLinkFacetAttributesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest,
      ListTypedLinkFacetAttributesResponse,
      TypedLinkAttributeDefinition
    ](
      "listTypedLinkFacetAttributes",
      api.listTypedLinkFacetAttributes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.attributes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.wrap(item)
      )
      .provideEnvironment(r)
    def listTypedLinkFacetAttributesPaginated(
        request: ListTypedLinkFacetAttributesRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetAttributesRequest,
      ListTypedLinkFacetAttributesResponse
    ]("listTypedLinkFacetAttributes", api.listTypedLinkFacetAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.wrap
    ).provideEnvironment(r)
    def attachPolicy(request: AttachPolicyRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.AttachPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.AttachPolicyRequest,
      AttachPolicyResponse
    ]("attachPolicy", api.attachPolicy)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.AttachPolicyResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.clouddirectory.model.Tag.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse,
        Tag
      ](
        "listTagsForResource",
        api.listTagsForResource,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.clouddirectory.model.Tag.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def updateObjectAttributes(request: UpdateObjectAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest,
      UpdateObjectAttributesResponse
    ]("updateObjectAttributes", api.updateObjectAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.wrap)
      .provideEnvironment(r)
    def addFacetToObject(request: AddFacetToObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.AddFacetToObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.AddFacetToObjectRequest,
      AddFacetToObjectResponse
    ]("addFacetToObject", api.addFacetToObject)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.AddFacetToObjectResponse.wrap)
      .provideEnvironment(r)
    def getTypedLinkFacetInformation(
        request: GetTypedLinkFacetInformationRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetTypedLinkFacetInformationRequest,
      GetTypedLinkFacetInformationResponse
    ]("getTypedLinkFacetInformation", api.getTypedLinkFacetInformation)(
      request.buildAwsValue()
    ).map(
      zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.wrap
    ).provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createDirectory(request: CreateDirectoryRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryRequest,
      CreateDirectoryResponse
    ]("createDirectory", api.createDirectory)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.CreateDirectoryResponse.wrap)
      .provideEnvironment(r)
    def getLinkAttributes(request: GetLinkAttributesRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetLinkAttributesRequest,
      GetLinkAttributesResponse
    ]("getLinkAttributes", api.getLinkAttributes)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.GetLinkAttributesResponse.wrap)
      .provideEnvironment(r)
    def createSchema(request: CreateSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.CreateSchemaRequest,
      CreateSchemaResponse
    ]("createSchema", api.createSchema)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.CreateSchemaResponse.wrap)
      .provideEnvironment(r)
    def getObjectInformation(request: GetObjectInformationRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetObjectInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetObjectInformationRequest,
      GetObjectInformationResponse
    ]("getObjectInformation", api.getObjectInformation)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.GetObjectInformationResponse.wrap)
      .provideEnvironment(r)
    def listIndex(request: ListIndexRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest,
      ListIndexResponse,
      IndexAttachment
    ](
      "listIndex",
      api.listIndex,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.indexAttachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.IndexAttachment.wrap(item))
      .provideEnvironment(r)
    def listIndexPaginated(
        request: ListIndexRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.ListIndexRequest,
        ListIndexResponse
      ]("listIndex", api.listIndex)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.ListIndexResponse.wrap)
        .provideEnvironment(r)
    def detachFromIndex(request: DetachFromIndexRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexRequest,
      DetachFromIndexResponse
    ]("detachFromIndex", api.detachFromIndex)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DetachFromIndexResponse.wrap)
      .provideEnvironment(r)
    def publishSchema(request: PublishSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.PublishSchemaRequest,
      PublishSchemaResponse
    ]("publishSchema", api.publishSchema)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.PublishSchemaResponse.wrap)
      .provideEnvironment(r)
    def deleteSchema(request: DeleteSchemaRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DeleteSchemaRequest,
      DeleteSchemaResponse
    ]("deleteSchema", api.deleteSchema)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DeleteSchemaResponse.wrap)
      .provideEnvironment(r)
    def listOutgoingTypedLinks(request: ListOutgoingTypedLinksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest,
      ListOutgoingTypedLinksResponse,
      TypedLinkSpecifier
    ](
      "listOutgoingTypedLinks",
      api.listOutgoingTypedLinks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.typedLinkSpecifiers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item))
      .provideEnvironment(r)
    def listOutgoingTypedLinksPaginated(
        request: ListOutgoingTypedLinksRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListOutgoingTypedLinksRequest,
      ListOutgoingTypedLinksResponse
    ]("listOutgoingTypedLinks", api.listOutgoingTypedLinks)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.wrap)
      .provideEnvironment(r)
    def getDirectory(request: GetDirectoryRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.GetDirectoryRequest,
      GetDirectoryResponse
    ]("getDirectory", api.getDirectory)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.GetDirectoryResponse.wrap)
      .provideEnvironment(r)
    def listPublishedSchemaArns(
        request: ListPublishedSchemaArnsRequest
    ): ZStream[Any, AwsError, Arn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest,
      ListPublishedSchemaArnsResponse,
      java.lang.String
    ](
      "listPublishedSchemaArns",
      api.listPublishedSchemaArns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemaArns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.Arn(item))
      .provideEnvironment(r)
    def listPublishedSchemaArnsPaginated(
        request: ListPublishedSchemaArnsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest,
      ListPublishedSchemaArnsResponse
    ]("listPublishedSchemaArns", api.listPublishedSchemaArns)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.wrap)
      .provideEnvironment(r)
    def listPolicyAttachments(
        request: ListPolicyAttachmentsRequest
    ): ZStream[Any, AwsError, ObjectIdentifier] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest,
      ListPolicyAttachmentsResponse,
      java.lang.String
    ](
      "listPolicyAttachments",
      api.listPolicyAttachments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.objectIdentifiers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(item)
      )
      .provideEnvironment(r)
    def listPolicyAttachmentsPaginated(
        request: ListPolicyAttachmentsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsRequest,
      ListPolicyAttachmentsResponse
    ]("listPolicyAttachments", api.listPolicyAttachments)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.wrap)
      .provideEnvironment(r)
    def deleteDirectory(request: DeleteDirectoryRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DeleteDirectoryRequest,
      DeleteDirectoryResponse
    ]("deleteDirectory", api.deleteDirectory)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DeleteDirectoryResponse.wrap)
      .provideEnvironment(r)
    def detachObject(request: DetachObjectRequest): IO[
      AwsError,
      zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.DetachObjectRequest,
      DetachObjectResponse
    ]("detachObject", api.detachObject)(request.buildAwsValue())
      .map(zio.aws.clouddirectory.model.DetachObjectResponse.wrap)
      .provideEnvironment(r)
    def batchRead(
        request: BatchReadRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.BatchReadRequest,
        BatchReadResponse
      ]("batchRead", api.batchRead)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.BatchReadResponse.wrap)
        .provideEnvironment(r)
    def listIncomingTypedLinks(request: ListIncomingTypedLinksRequest): ZStream[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest,
      ListIncomingTypedLinksResponse,
      TypedLinkSpecifier
    ](
      "listIncomingTypedLinks",
      api.listIncomingTypedLinks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.linkSpecifiers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.TypedLinkSpecifier.wrap(item))
      .provideEnvironment(r)
    def listIncomingTypedLinksPaginated(
        request: ListIncomingTypedLinksRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListIncomingTypedLinksRequest,
      ListIncomingTypedLinksResponse
    ]("listIncomingTypedLinks", api.listIncomingTypedLinks)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.wrap)
      .provideEnvironment(r)
    def listDevelopmentSchemaArns(
        request: ListDevelopmentSchemaArnsRequest
    ): ZStream[Any, AwsError, Arn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest,
      ListDevelopmentSchemaArnsResponse,
      java.lang.String
    ](
      "listDevelopmentSchemaArns",
      api.listDevelopmentSchemaArns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemaArns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.Arn(item))
      .provideEnvironment(r)
    def listDevelopmentSchemaArnsPaginated(
        request: ListDevelopmentSchemaArnsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest,
      ListDevelopmentSchemaArnsResponse
    ]("listDevelopmentSchemaArns", api.listDevelopmentSchemaArns)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.wrap)
      .provideEnvironment(r)
    def createIndex(
        request: CreateIndexRequest
    ): IO[AwsError, zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.clouddirectory.model.CreateIndexRequest,
        CreateIndexResponse
      ]("createIndex", api.createIndex)(request.buildAwsValue())
        .map(zio.aws.clouddirectory.model.CreateIndexResponse.wrap)
        .provideEnvironment(r)
    def listAppliedSchemaArns(
        request: ListAppliedSchemaArnsRequest
    ): ZStream[Any, AwsError, Arn] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest,
      ListAppliedSchemaArnsResponse,
      java.lang.String
    ](
      "listAppliedSchemaArns",
      api.listAppliedSchemaArns,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.schemaArns().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.clouddirectory.model.primitives.Arn(item))
      .provideEnvironment(r)
    def listAppliedSchemaArnsPaginated(
        request: ListAppliedSchemaArnsRequest
    ): IO[
      AwsError,
      zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest,
      ListAppliedSchemaArnsResponse
    ]("listAppliedSchemaArns", api.listAppliedSchemaArns)(
      request.buildAwsValue()
    ).map(zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.wrap)
      .provideEnvironment(r)
  }
  def listObjectParentPaths(request: ListObjectParentPathsRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
  ] = ZStream.serviceWithStream(_.listObjectParentPaths(request))
  def listObjectParentPathsPaginated(
      request: ListObjectParentPathsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectParentPathsPaginated(request))
  def listDirectories(request: ListDirectoriesRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.Directory.ReadOnly
  ] = ZStream.serviceWithStream(_.listDirectories(request))
  def listDirectoriesPaginated(request: ListDirectoriesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDirectoriesPaginated(request))
  def listAttachedIndices(request: ListAttachedIndicesRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
  ] = ZStream.serviceWithStream(_.listAttachedIndices(request))
  def listAttachedIndicesPaginated(request: ListAttachedIndicesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListAttachedIndicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAttachedIndicesPaginated(request))
  def attachToIndex(request: AttachToIndexRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachToIndex(request))
  def listObjectAttributes(request: ListObjectAttributesRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
  ] = ZStream.serviceWithStream(_.listObjectAttributes(request))
  def listObjectAttributesPaginated(request: ListObjectAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectAttributesPaginated(request))
  def batchWrite(request: BatchWriteRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchWrite(request))
  def deleteFacet(request: DeleteFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DeleteFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFacet(request))
  def attachTypedLink(request: AttachTypedLinkRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachTypedLink(request))
  def listFacetAttributes(request: ListFacetAttributesRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
  ] = ZStream.serviceWithStream(_.listFacetAttributes(request))
  def listFacetAttributesPaginated(request: ListFacetAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFacetAttributesPaginated(request))
  def lookupPolicy(request: LookupPolicyRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
  ] = ZStream.serviceWithStream(_.lookupPolicy(request))
  def lookupPolicyPaginated(request: LookupPolicyRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.lookupPolicyPaginated(request))
  def attachObject(request: AttachObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachObject(request))
  def listObjectParents(
      request: ListObjectParentsRequest
  ): ZIO[zio.aws.clouddirectory.CloudDirectory, AwsError, StreamingOutputResult[
    Any,
    zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly,
    zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listObjectParents(request))
  def listObjectParentsPaginated(request: ListObjectParentsRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectParentsPaginated(request))
  def getAppliedSchemaVersion(request: GetAppliedSchemaVersionRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppliedSchemaVersion(request))
  def updateLinkAttributes(request: UpdateLinkAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLinkAttributes(request))
  def getObjectAttributes(request: GetObjectAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectAttributes(request))
  def upgradePublishedSchema(request: UpgradePublishedSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.upgradePublishedSchema(request))
  def putSchemaFromJson(request: PutSchemaFromJsonRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putSchemaFromJson(request))
  def listManagedSchemaArns(
      request: ListManagedSchemaArnsRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, Arn] =
    ZStream.serviceWithStream(_.listManagedSchemaArns(request))
  def listManagedSchemaArnsPaginated(
      request: ListManagedSchemaArnsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedSchemaArnsPaginated(request))
  def enableDirectory(request: EnableDirectoryRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableDirectory(request))
  def detachPolicy(
      request: DetachPolicyRequest
  ): ZIO[zio.aws.clouddirectory.CloudDirectory, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.detachPolicy(request))
  def updateTypedLinkFacet(request: UpdateTypedLinkFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTypedLinkFacet(request))
  def deleteTypedLinkFacet(request: DeleteTypedLinkFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTypedLinkFacet(request))
  def upgradeAppliedSchema(request: UpgradeAppliedSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.upgradeAppliedSchema(request))
  def deleteObject(request: DeleteObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DeleteObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteObject(request))
  def createTypedLinkFacet(request: CreateTypedLinkFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTypedLinkFacet(request))
  def updateFacet(request: UpdateFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpdateFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFacet(request))
  def listObjectPolicies(request: ListObjectPoliciesRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    ObjectIdentifier
  ] = ZStream.serviceWithStream(_.listObjectPolicies(request))
  def listObjectPoliciesPaginated(request: ListObjectPoliciesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectPoliciesPaginated(request))
  def listTypedLinkFacetNames(
      request: ListTypedLinkFacetNamesRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, TypedLinkName] =
    ZStream.serviceWithStream(_.listTypedLinkFacetNames(request))
  def listTypedLinkFacetNamesPaginated(
      request: ListTypedLinkFacetNamesRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypedLinkFacetNamesPaginated(request))
  def removeFacetFromObject(request: RemoveFacetFromObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeFacetFromObject(request))
  def disableDirectory(request: DisableDirectoryRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableDirectory(request))
  def getFacet(request: GetFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFacet(request))
  def createObject(request: CreateObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createObject(request))
  def updateSchema(request: UpdateSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpdateSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSchema(request))
  def getSchemaAsJson(request: GetSchemaAsJsonRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSchemaAsJson(request))
  def createFacet(request: CreateFacetRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateFacetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFacet(request))
  def detachTypedLink(
      request: DetachTypedLinkRequest
  ): ZIO[zio.aws.clouddirectory.CloudDirectory, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachTypedLink(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listObjectChildren(
      request: ListObjectChildrenRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, Tuple2[
    LinkName,
    ObjectIdentifier
  ]] = ZStream.serviceWithStream(_.listObjectChildren(request))
  def listObjectChildrenPaginated(request: ListObjectChildrenRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listObjectChildrenPaginated(request))
  def applySchema(request: ApplySchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applySchema(request))
  def listFacetNames(
      request: ListFacetNamesRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, FacetName] =
    ZStream.serviceWithStream(_.listFacetNames(request))
  def listFacetNamesPaginated(request: ListFacetNamesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFacetNamesPaginated(request))
  def listTypedLinkFacetAttributes(
      request: ListTypedLinkFacetAttributesRequest
  ): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
  ] = ZStream.serviceWithStream(_.listTypedLinkFacetAttributes(request))
  def listTypedLinkFacetAttributesPaginated(
      request: ListTypedLinkFacetAttributesRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTypedLinkFacetAttributesPaginated(request))
  def attachPolicy(request: AttachPolicyRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AttachPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachPolicy(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.Tag.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def updateObjectAttributes(request: UpdateObjectAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateObjectAttributes(request))
  def addFacetToObject(request: AddFacetToObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.AddFacetToObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addFacetToObject(request))
  def getTypedLinkFacetInformation(
      request: GetTypedLinkFacetInformationRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTypedLinkFacetInformation(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createDirectory(request: CreateDirectoryRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDirectory(request))
  def getLinkAttributes(request: GetLinkAttributesRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLinkAttributes(request))
  def createSchema(request: CreateSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSchema(request))
  def getObjectInformation(request: GetObjectInformationRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetObjectInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getObjectInformation(request))
  def listIndex(request: ListIndexRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
  ] = ZStream.serviceWithStream(_.listIndex(request))
  def listIndexPaginated(request: ListIndexRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIndexPaginated(request))
  def detachFromIndex(request: DetachFromIndexRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachFromIndex(request))
  def publishSchema(request: PublishSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.publishSchema(request))
  def deleteSchema(request: DeleteSchemaRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSchema(request))
  def listOutgoingTypedLinks(request: ListOutgoingTypedLinksRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listOutgoingTypedLinks(request))
  def listOutgoingTypedLinksPaginated(
      request: ListOutgoingTypedLinksRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listOutgoingTypedLinksPaginated(request))
  def getDirectory(request: GetDirectoryRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDirectory(request))
  def listPublishedSchemaArns(
      request: ListPublishedSchemaArnsRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, Arn] =
    ZStream.serviceWithStream(_.listPublishedSchemaArns(request))
  def listPublishedSchemaArnsPaginated(
      request: ListPublishedSchemaArnsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPublishedSchemaArnsPaginated(request))
  def listPolicyAttachments(request: ListPolicyAttachmentsRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    ObjectIdentifier
  ] = ZStream.serviceWithStream(_.listPolicyAttachments(request))
  def listPolicyAttachmentsPaginated(
      request: ListPolicyAttachmentsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPolicyAttachmentsPaginated(request))
  def deleteDirectory(request: DeleteDirectoryRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDirectory(request))
  def detachObject(request: DetachObjectRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachObject(request))
  def batchRead(request: BatchReadRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchRead(request))
  def listIncomingTypedLinks(request: ListIncomingTypedLinksRequest): ZStream[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
  ] = ZStream.serviceWithStream(_.listIncomingTypedLinks(request))
  def listIncomingTypedLinksPaginated(
      request: ListIncomingTypedLinksRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listIncomingTypedLinksPaginated(request))
  def listDevelopmentSchemaArns(
      request: ListDevelopmentSchemaArnsRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, Arn] =
    ZStream.serviceWithStream(_.listDevelopmentSchemaArns(request))
  def listDevelopmentSchemaArnsPaginated(
      request: ListDevelopmentSchemaArnsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDevelopmentSchemaArnsPaginated(request))
  def createIndex(request: CreateIndexRequest): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIndex(request))
  def listAppliedSchemaArns(
      request: ListAppliedSchemaArnsRequest
  ): ZStream[zio.aws.clouddirectory.CloudDirectory, AwsError, Arn] =
    ZStream.serviceWithStream(_.listAppliedSchemaArns(request))
  def listAppliedSchemaArnsPaginated(
      request: ListAppliedSchemaArnsRequest
  ): ZIO[
    zio.aws.clouddirectory.CloudDirectory,
    AwsError,
    zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppliedSchemaArnsPaginated(request))
}
