package zio.aws.clouddirectory
import zio.aws.clouddirectory.model.primitives.PolicyType.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.clouddirectory.model.primitives.{
  AttributeName,
  LinkName,
  Arn,
  TypedLinkName,
  RuleParameterValue,
  RuleKey,
  FacetName,
  RuleParameterKey,
  ObjectIdentifier,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.clouddirectory.model.primitives.Arn.Type
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.clouddirectory.model.primitives.AttributeName.Type
    object BatchReferenceName extends Subtype[String]
    type BatchReferenceName =
      zio.aws.clouddirectory.model.primitives.BatchReferenceName.Type
    object BinaryAttributeValue extends Subtype[Chunk[Byte]]
    type BinaryAttributeValue =
      zio.aws.clouddirectory.model.primitives.BinaryAttributeValue.Type
    type Bool = Boolean
    object BooleanAttributeValue extends Subtype[Boolean]
    type BooleanAttributeValue =
      zio.aws.clouddirectory.model.primitives.BooleanAttributeValue.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.clouddirectory.model.primitives.Date.Type
    object DatetimeAttributeValue extends Subtype[Instant]
    type DatetimeAttributeValue =
      zio.aws.clouddirectory.model.primitives.DatetimeAttributeValue.Type
    object DirectoryArn extends Subtype[String]
    type DirectoryArn =
      zio.aws.clouddirectory.model.primitives.DirectoryArn.Type
    object DirectoryName extends Subtype[String]
    type DirectoryName =
      zio.aws.clouddirectory.model.primitives.DirectoryName.Type
    object ExceptionMessage extends Subtype[String]
    type ExceptionMessage =
      zio.aws.clouddirectory.model.primitives.ExceptionMessage.Type
    object FacetName extends Subtype[String]
    type FacetName = zio.aws.clouddirectory.model.primitives.FacetName.Type
    object LinkName extends Subtype[String]
    type LinkName = zio.aws.clouddirectory.model.primitives.LinkName.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.clouddirectory.model.primitives.NextToken.Type
    object NumberAttributeValue extends Subtype[String]
    type NumberAttributeValue =
      zio.aws.clouddirectory.model.primitives.NumberAttributeValue.Type
    object NumberResults extends Subtype[Int]
    type NumberResults =
      zio.aws.clouddirectory.model.primitives.NumberResults.Type
    object ObjectIdentifier extends Subtype[String]
    type ObjectIdentifier =
      zio.aws.clouddirectory.model.primitives.ObjectIdentifier.Type
    object PathString extends Subtype[String]
    type PathString = zio.aws.clouddirectory.model.primitives.PathString.Type
    object PolicyType extends Subtype[String]
    type PolicyType = zio.aws.clouddirectory.model.primitives.PolicyType.Type
    object RuleKey extends Subtype[String]
    type RuleKey = zio.aws.clouddirectory.model.primitives.RuleKey.Type
    object RuleParameterKey extends Subtype[String]
    type RuleParameterKey =
      zio.aws.clouddirectory.model.primitives.RuleParameterKey.Type
    object RuleParameterValue extends Subtype[String]
    type RuleParameterValue =
      zio.aws.clouddirectory.model.primitives.RuleParameterValue.Type
    object SchemaJsonDocument extends Subtype[String]
    type SchemaJsonDocument =
      zio.aws.clouddirectory.model.primitives.SchemaJsonDocument.Type
    object SchemaName extends Subtype[String]
    type SchemaName = zio.aws.clouddirectory.model.primitives.SchemaName.Type
    object SelectorObjectReference extends Subtype[String]
    type SelectorObjectReference =
      zio.aws.clouddirectory.model.primitives.SelectorObjectReference.Type
    object StringAttributeValue extends Subtype[String]
    type StringAttributeValue =
      zio.aws.clouddirectory.model.primitives.StringAttributeValue.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.clouddirectory.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.clouddirectory.model.primitives.TagValue.Type
    object TagsNumberResults extends Subtype[Int]
    type TagsNumberResults =
      zio.aws.clouddirectory.model.primitives.TagsNumberResults.Type
    object TypedLinkName extends Subtype[String]
    type TypedLinkName =
      zio.aws.clouddirectory.model.primitives.TypedLinkName.Type
    object Version extends Subtype[String]
    type Version = zio.aws.clouddirectory.model.primitives.Version.Type
  }
  type Arns = List[Arn]
  type AttributeKeyAndValueList =
    List[zio.aws.clouddirectory.model.AttributeKeyAndValue]
  type AttributeKeyList = List[zio.aws.clouddirectory.model.AttributeKey]
  type AttributeNameAndValueList =
    List[zio.aws.clouddirectory.model.AttributeNameAndValue]
  type AttributeNameList = List[AttributeName]
  type BatchReadOperationList =
    List[zio.aws.clouddirectory.model.BatchReadOperation]
  type BatchReadOperationResponseList =
    List[zio.aws.clouddirectory.model.BatchReadOperationResponse]
  type BatchWriteOperationList =
    List[zio.aws.clouddirectory.model.BatchWriteOperation]
  type BatchWriteOperationResponseList =
    List[zio.aws.clouddirectory.model.BatchWriteOperationResponse]
  type DirectoryList = List[zio.aws.clouddirectory.model.Directory]
  type FacetAttributeList = List[zio.aws.clouddirectory.model.FacetAttribute]
  type FacetAttributeUpdateList =
    List[zio.aws.clouddirectory.model.FacetAttributeUpdate]
  type FacetNameList = List[FacetName]
  type IndexAttachmentList = List[zio.aws.clouddirectory.model.IndexAttachment]
  type LinkAttributeUpdateList =
    List[zio.aws.clouddirectory.model.LinkAttributeUpdate]
  type LinkNameToObjectIdentifierMap = Map[LinkName, ObjectIdentifier]
  type ObjectAttributeRangeList =
    List[zio.aws.clouddirectory.model.ObjectAttributeRange]
  type ObjectAttributeUpdateList =
    List[zio.aws.clouddirectory.model.ObjectAttributeUpdate]
  type ObjectIdentifierAndLinkNameList =
    List[zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple]
  type ObjectIdentifierList = List[ObjectIdentifier]
  type ObjectIdentifierToLinkNameMap = Map[ObjectIdentifier, LinkName]
  type PathToObjectIdentifiersList =
    List[zio.aws.clouddirectory.model.PathToObjectIdentifiers]
  type PolicyAttachmentList =
    List[zio.aws.clouddirectory.model.PolicyAttachment]
  type PolicyToPathList = List[zio.aws.clouddirectory.model.PolicyToPath]
  type RuleMap = Map[RuleKey, zio.aws.clouddirectory.model.Rule]
  type RuleParameterMap = Map[RuleParameterKey, RuleParameterValue]
  type SchemaFacetList = List[zio.aws.clouddirectory.model.SchemaFacet]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.clouddirectory.model.Tag]
  type TypedLinkAttributeDefinitionList =
    List[zio.aws.clouddirectory.model.TypedLinkAttributeDefinition]
  type TypedLinkAttributeRangeList =
    List[zio.aws.clouddirectory.model.TypedLinkAttributeRange]
  type TypedLinkFacetAttributeUpdateList =
    List[zio.aws.clouddirectory.model.TypedLinkFacetAttributeUpdate]
  type TypedLinkNameList = List[TypedLinkName]
  type TypedLinkSpecifierList =
    List[zio.aws.clouddirectory.model.TypedLinkSpecifier]
}
