package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LookupPolicyResponse(
    policyToPathList: Optional[
      Iterable[zio.aws.clouddirectory.model.PolicyToPath]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse = {
    import LookupPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse
      .builder()
      .optionallyWith(
        policyToPathList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyToPathList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly =
    zio.aws.clouddirectory.model.LookupPolicyResponse.wrap(buildAwsValue())
}
object LookupPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.LookupPolicyResponse =
      zio.aws.clouddirectory.model.LookupPolicyResponse(
        policyToPathList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def policyToPathList
        : Optional[List[zio.aws.clouddirectory.model.PolicyToPath.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getPolicyToPathList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
    ]] = AwsError.unwrapOptionField("policyToPathList", policyToPathList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse
  ) extends zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly {
    override val policyToPathList
        : Optional[List[zio.aws.clouddirectory.model.PolicyToPath.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyToPathList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.PolicyToPath.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.LookupPolicyResponse
  ): zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
