package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class LookupPolicyRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest = {
    import LookupPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.LookupPolicyRequest.ReadOnly =
    zio.aws.clouddirectory.model.LookupPolicyRequest.wrap(buildAwsValue())
}
object LookupPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.LookupPolicyRequest =
      zio.aws.clouddirectory.model.LookupPolicyRequest(
        directoryArn,
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest
  ) extends zio.aws.clouddirectory.model.LookupPolicyRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.LookupPolicyRequest
  ): zio.aws.clouddirectory.model.LookupPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
