package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, TypedLinkName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTypedLinkFacetNamesResponse(
    facetNames: Optional[Iterable[TypedLinkName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse = {
    import ListTypedLinkFacetNamesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse
      .builder()
      .optionallyWith(
        facetNames.map(value =>
          value.map { item =>
            TypedLinkName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.facetNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse
      .wrap(buildAwsValue())
}
object ListTypedLinkFacetNamesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse =
      zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse(
        facetNames.map(value => value),
        nextToken.map(value => value)
      )
    def facetNames: Optional[List[TypedLinkName]]
    def nextToken: Optional[NextToken]
    def getFacetNames: ZIO[Any, AwsError, List[TypedLinkName]] =
      AwsError.unwrapOptionField("facetNames", facetNames)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse
  ) extends zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly {
    override val facetNames: Optional[List[TypedLinkName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facetNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.primitives.TypedLinkName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTypedLinkFacetNamesResponse
  ): zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly =
    new Wrapper(impl)
}
