package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  NextToken,
  ObjectIdentifier,
  LinkName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchListObjectChildrenResponse(
    children: Optional[Map[LinkName, ObjectIdentifier]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse = {
    import BatchListObjectChildrenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse
      .builder()
      .optionallyWith(
        children.map(value =>
          value
            .map({ case (key, value) =>
              (LinkName.unwrap(key): java.lang.String) -> (ObjectIdentifier
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.children)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListObjectChildrenResponse
      .wrap(buildAwsValue())
}
object BatchListObjectChildrenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListObjectChildrenResponse =
      zio.aws.clouddirectory.model.BatchListObjectChildrenResponse(
        children.map(value => value),
        nextToken.map(value => value)
      )
    def children: Optional[Map[LinkName, ObjectIdentifier]]
    def nextToken: Optional[NextToken]
    def getChildren: ZIO[Any, AwsError, Map[LinkName, ObjectIdentifier]] =
      AwsError.unwrapOptionField("children", children)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse
  ) extends zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly {
    override val children: Optional[Map[LinkName, ObjectIdentifier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.children())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.clouddirectory.model.primitives
                .LinkName(key) -> zio.aws.clouddirectory.model.primitives
                .ObjectIdentifier(value)
            })
            .toMap
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectChildrenResponse
  ): zio.aws.clouddirectory.model.BatchListObjectChildrenResponse.ReadOnly =
    new Wrapper(impl)
}
