package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.PathString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyToPath(
    path: Optional[PathString] = Optional.Absent,
    policies: Optional[
      Iterable[zio.aws.clouddirectory.model.PolicyAttachment]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PolicyToPath = {
    import PolicyToPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PolicyToPath
      .builder()
      .optionallyWith(
        path.map(value => PathString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.PolicyToPath.ReadOnly =
    zio.aws.clouddirectory.model.PolicyToPath.wrap(buildAwsValue())
}
object PolicyToPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PolicyToPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PolicyToPath =
      zio.aws.clouddirectory.model.PolicyToPath(
        path.map(value => value),
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def path: Optional[PathString]
    def policies
        : Optional[List[zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly]]
    def getPath: ZIO[Any, AwsError, PathString] =
      AwsError.unwrapOptionField("path", path)
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PolicyToPath
  ) extends zio.aws.clouddirectory.model.PolicyToPath.ReadOnly {
    override val path: Optional[PathString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.clouddirectory.model.primitives.PathString(value))
    override val policies: Optional[
      List[zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.PolicyAttachment.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PolicyToPath
  ): zio.aws.clouddirectory.model.PolicyToPath.ReadOnly = new Wrapper(impl)
}
