package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{LinkName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AttachObjectRequest(
    directoryArn: Arn,
    parentReference: zio.aws.clouddirectory.model.ObjectReference,
    childReference: zio.aws.clouddirectory.model.ObjectReference,
    linkName: LinkName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest = {
    import AttachObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .parentReference(parentReference.buildAwsValue())
      .childReference(childReference.buildAwsValue())
      .linkName(LinkName.unwrap(linkName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.AttachObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.AttachObjectRequest.wrap(buildAwsValue())
}
object AttachObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.AttachObjectRequest =
      zio.aws.clouddirectory.model.AttachObjectRequest(
        directoryArn,
        parentReference.asEditable,
        childReference.asEditable,
        linkName
      )
    def directoryArn: Arn
    def parentReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def childReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def linkName: LinkName
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getParentReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(parentReference)
    def getChildReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(childReference)
    def getLinkName: ZIO[Any, Nothing, LinkName] = ZIO.succeed(linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest
  ) extends zio.aws.clouddirectory.model.AttachObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val parentReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.parentReference())
    override val childReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.childReference())
    override val linkName: LinkName =
      zio.aws.clouddirectory.model.primitives.LinkName(impl.linkName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.AttachObjectRequest
  ): zio.aws.clouddirectory.model.AttachObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
