package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters._
sealed trait DirectoryState {
  def unwrap
      : software.amazon.awssdk.services.clouddirectory.model.DirectoryState
}
object DirectoryState {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.DirectoryState
  ): zio.aws.clouddirectory.model.DirectoryState = value match {
    case software.amazon.awssdk.services.clouddirectory.model.DirectoryState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.DirectoryState.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.clouddirectory.model.DirectoryState.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.clouddirectory.model.DirectoryState.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.DirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.DirectoryState =
      software.amazon.awssdk.services.clouddirectory.model.DirectoryState.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.clouddirectory.model.DirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.DirectoryState =
      software.amazon.awssdk.services.clouddirectory.model.DirectoryState.ENABLED
  }
  case object DISABLED extends zio.aws.clouddirectory.model.DirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.DirectoryState =
      software.amazon.awssdk.services.clouddirectory.model.DirectoryState.DISABLED
  }
  case object DELETED extends zio.aws.clouddirectory.model.DirectoryState {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.DirectoryState =
      software.amazon.awssdk.services.clouddirectory.model.DirectoryState.DELETED
  }
}
