package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    tags: Optional[Iterable[zio.aws.clouddirectory.model.Tag]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListTagsForResourceResponse
      .wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListTagsForResourceResponse =
      zio.aws.clouddirectory.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Optional[List[zio.aws.clouddirectory.model.Tag.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.clouddirectory.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse
  ) extends zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly {
    override val tags
        : Optional[List[zio.aws.clouddirectory.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.Tag.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListTagsForResourceResponse
  ): zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
