package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{
  Bool,
  NumberResults,
  NextToken,
  Arn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListObjectParentsRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent,
    consistencyLevel: Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      Optional.Absent,
    includeAllLinksToEachParent: Optional[Bool] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest = {
    import ListObjectParentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(consistencyLevel.map(value => value.unwrap))(
        _.consistencyLevel
      )
      .optionallyWith(
        includeAllLinksToEachParent.map(value => value: java.lang.Boolean)
      )(_.includeAllLinksToEachParent)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectParentsRequest.wrap(buildAwsValue())
}
object ListObjectParentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectParentsRequest =
      zio.aws.clouddirectory.model.ListObjectParentsRequest(
        directoryArn,
        objectReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value),
        consistencyLevel.map(value => value),
        includeAllLinksToEachParent.map(value => value)
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel]
    def includeAllLinksToEachParent: Optional[Bool]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getConsistencyLevel
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ConsistencyLevel] =
      AwsError.unwrapOptionField("consistencyLevel", consistencyLevel)
    def getIncludeAllLinksToEachParent: ZIO[Any, AwsError, Bool] =
      AwsError.unwrapOptionField(
        "includeAllLinksToEachParent",
        includeAllLinksToEachParent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ) extends zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
    override val consistencyLevel
        : Optional[zio.aws.clouddirectory.model.ConsistencyLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.consistencyLevel())
        .map(value => zio.aws.clouddirectory.model.ConsistencyLevel.wrap(value))
    override val includeAllLinksToEachParent: Optional[Bool] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeAllLinksToEachParent())
        .map(value => value: Bool)
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectParentsRequest
  ): zio.aws.clouddirectory.model.ListObjectParentsRequest.ReadOnly =
    new Wrapper(impl)
}
