package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, ObjectIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListObjectPoliciesResponse(
    attachedPolicyIds: Optional[Iterable[ObjectIdentifier]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse = {
    import ListObjectPoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse
      .builder()
      .optionallyWith(
        attachedPolicyIds.map(value =>
          value.map { item =>
            ObjectIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.attachedPolicyIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListObjectPoliciesResponse
      .wrap(buildAwsValue())
}
object ListObjectPoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListObjectPoliciesResponse =
      zio.aws.clouddirectory.model.ListObjectPoliciesResponse(
        attachedPolicyIds.map(value => value),
        nextToken.map(value => value)
      )
    def attachedPolicyIds: Optional[List[ObjectIdentifier]]
    def nextToken: Optional[NextToken]
    def getAttachedPolicyIds: ZIO[Any, AwsError, List[ObjectIdentifier]] =
      AwsError.unwrapOptionField("attachedPolicyIds", attachedPolicyIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse
  ) extends zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly {
    override val attachedPolicyIds: Optional[List[ObjectIdentifier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachedPolicyIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.primitives.ObjectIdentifier(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListObjectPoliciesResponse
  ): zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly =
    new Wrapper(impl)
}
