package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken, Arn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListManagedSchemaArnsRequest(
    schemaArn: Optional[Arn] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest = {
    import ListManagedSchemaArnsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
      .builder()
      .optionallyWith(
        schemaArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.schemaArn)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly =
    zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest
      .wrap(buildAwsValue())
}
object ListManagedSchemaArnsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest =
      zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest(
        schemaArn.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def schemaArn: Optional[Arn]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def getSchemaArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("schemaArn", schemaArn)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ) extends zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly {
    override val schemaArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.schemaArn())
      .map(value => zio.aws.clouddirectory.model.primitives.Arn(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest
  ): zio.aws.clouddirectory.model.ListManagedSchemaArnsRequest.ReadOnly =
    new Wrapper(impl)
}
