package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveFacetFromObjectRequest(
    directoryArn: Arn,
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest = {
    import RemoveFacetFromObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .schemaFacet(schemaFacet.buildAwsValue())
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest.ReadOnly =
    zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest
      .wrap(buildAwsValue())
}
object RemoveFacetFromObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest =
      zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest(
        directoryArn,
        schemaFacet.asEditable,
        objectReference.asEditable
      )
    def directoryArn: Arn
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest
  ) extends zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.RemoveFacetFromObjectRequest
  ): zio.aws.clouddirectory.model.RemoveFacetFromObjectRequest.ReadOnly =
    new Wrapper(impl)
}
