package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetAppliedSchemaVersionRequest(schemaArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest = {
    import GetAppliedSchemaVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest.ReadOnly =
    zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest
      .wrap(buildAwsValue())
}
object GetAppliedSchemaVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest =
      zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest(schemaArn)
    def schemaArn: Arn
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest
  ) extends zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetAppliedSchemaVersionRequest
  ): zio.aws.clouddirectory.model.GetAppliedSchemaVersionRequest.ReadOnly =
    new Wrapper(impl)
}
