package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchUpdateObjectAttributesResponse(
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse = {
    import BatchUpdateObjectAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
      .builder()
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse
      .wrap(buildAwsValue())
}
object BatchUpdateObjectAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse =
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse(
        objectIdentifier.map(value => value)
      )
    def objectIdentifier: Optional[ObjectIdentifier]
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ) extends zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly {
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse
  ): zio.aws.clouddirectory.model.BatchUpdateObjectAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
