package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplySchemaRequest(
    publishedSchemaArn: Arn,
    directoryArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest = {
    import ApplySchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest
      .builder()
      .publishedSchemaArn(Arn.unwrap(publishedSchemaArn): java.lang.String)
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ApplySchemaRequest.ReadOnly =
    zio.aws.clouddirectory.model.ApplySchemaRequest.wrap(buildAwsValue())
}
object ApplySchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ApplySchemaRequest =
      zio.aws.clouddirectory.model
        .ApplySchemaRequest(publishedSchemaArn, directoryArn)
    def publishedSchemaArn: Arn
    def directoryArn: Arn
    def getPublishedSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(publishedSchemaArn)
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest
  ) extends zio.aws.clouddirectory.model.ApplySchemaRequest.ReadOnly {
    override val publishedSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.publishedSchemaArn())
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ApplySchemaRequest
  ): zio.aws.clouddirectory.model.ApplySchemaRequest.ReadOnly = new Wrapper(
    impl
  )
}
