package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{
  Arn,
  ObjectIdentifier,
  DirectoryName,
  DirectoryArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateDirectoryResponse(
    directoryArn: DirectoryArn,
    name: DirectoryName,
    objectIdentifier: ObjectIdentifier,
    appliedSchemaArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse = {
    import CreateDirectoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse
      .builder()
      .directoryArn(DirectoryArn.unwrap(directoryArn): java.lang.String)
      .name(DirectoryName.unwrap(name): java.lang.String)
      .objectIdentifier(
        ObjectIdentifier.unwrap(objectIdentifier): java.lang.String
      )
      .appliedSchemaArn(Arn.unwrap(appliedSchemaArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly =
    zio.aws.clouddirectory.model.CreateDirectoryResponse.wrap(buildAwsValue())
}
object CreateDirectoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateDirectoryResponse =
      zio.aws.clouddirectory.model.CreateDirectoryResponse(
        directoryArn,
        name,
        objectIdentifier,
        appliedSchemaArn
      )
    def directoryArn: DirectoryArn
    def name: DirectoryName
    def objectIdentifier: ObjectIdentifier
    def appliedSchemaArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, DirectoryArn] =
      ZIO.succeed(directoryArn)
    def getName: ZIO[Any, Nothing, DirectoryName] = ZIO.succeed(name)
    def getObjectIdentifier: ZIO[Any, Nothing, ObjectIdentifier] =
      ZIO.succeed(objectIdentifier)
    def getAppliedSchemaArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(appliedSchemaArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse
  ) extends zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly {
    override val directoryArn: DirectoryArn =
      zio.aws.clouddirectory.model.primitives.DirectoryArn(impl.directoryArn())
    override val name: DirectoryName =
      zio.aws.clouddirectory.model.primitives.DirectoryName(impl.name())
    override val objectIdentifier: ObjectIdentifier =
      zio.aws.clouddirectory.model.primitives
        .ObjectIdentifier(impl.objectIdentifier())
    override val appliedSchemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.appliedSchemaArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateDirectoryResponse
  ): zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly =
    new Wrapper(impl)
}
