package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters._
sealed trait UpdateActionType {
  def unwrap
      : software.amazon.awssdk.services.clouddirectory.model.UpdateActionType
}
object UpdateActionType {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.UpdateActionType
  ): zio.aws.clouddirectory.model.UpdateActionType = value match {
    case software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.CREATE_OR_UPDATE =>
      val r = CREATE_OR_UPDATE
      r
    case software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.UpdateActionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.UpdateActionType =
      software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_OR_UPDATE
      extends zio.aws.clouddirectory.model.UpdateActionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.UpdateActionType =
      software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.CREATE_OR_UPDATE
  }
  case object DELETE extends zio.aws.clouddirectory.model.UpdateActionType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.UpdateActionType =
      software.amazon.awssdk.services.clouddirectory.model.UpdateActionType.DELETE
  }
}
