package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.AttributeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetObjectAttributes(
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    schemaFacet: zio.aws.clouddirectory.model.SchemaFacet,
    attributeNames: Iterable[AttributeName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes = {
    import BatchGetObjectAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .schemaFacet(schemaFacet.buildAwsValue())
      .attributeNames(attributeNames.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly =
    zio.aws.clouddirectory.model.BatchGetObjectAttributes.wrap(buildAwsValue())
}
object BatchGetObjectAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchGetObjectAttributes =
      zio.aws.clouddirectory.model.BatchGetObjectAttributes(
        objectReference.asEditable,
        schemaFacet.asEditable,
        attributeNames
      )
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def schemaFacet: zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    def attributeNames: List[AttributeName]
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getSchemaFacet
        : ZIO[Any, Nothing, zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] =
      ZIO.succeed(schemaFacet)
    def getAttributeNames: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(attributeNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes
  ) extends zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val schemaFacet
        : zio.aws.clouddirectory.model.SchemaFacet.ReadOnly =
      zio.aws.clouddirectory.model.SchemaFacet.wrap(impl.schemaFacet())
    override val attributeNames: List[AttributeName] = impl
      .attributeNames()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.primitives.AttributeName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectAttributes
  ): zio.aws.clouddirectory.model.BatchGetObjectAttributes.ReadOnly =
    new Wrapper(impl)
}
