package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{PolicyType, ObjectIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PolicyAttachment(
    policyId: Optional[ObjectIdentifier] = Optional.Absent,
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent,
    policyType: Optional[PolicyType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment = {
    import PolicyAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment
      .builder()
      .optionallyWith(
        policyId.map(value => ObjectIdentifier.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .optionallyWith(
        policyType.map(value => PolicyType.unwrap(value): java.lang.String)
      )(_.policyType)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly =
    zio.aws.clouddirectory.model.PolicyAttachment.wrap(buildAwsValue())
}
object PolicyAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.PolicyAttachment =
      zio.aws.clouddirectory.model.PolicyAttachment(
        policyId.map(value => value),
        objectIdentifier.map(value => value),
        policyType.map(value => value)
      )
    def policyId: Optional[ObjectIdentifier]
    def objectIdentifier: Optional[ObjectIdentifier]
    def policyType: Optional[PolicyType]
    def getPolicyId: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
    def getPolicyType: ZIO[Any, AwsError, PolicyType] =
      AwsError.unwrapOptionField("policyType", policyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment
  ) extends zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly {
    override val policyId: Optional[ObjectIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
      )
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
    override val policyType: Optional[PolicyType] = zio.aws.core.internal
      .optionalFromNullable(impl.policyType())
      .map(value => zio.aws.clouddirectory.model.primitives.PolicyType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.PolicyAttachment
  ): zio.aws.clouddirectory.model.PolicyAttachment.ReadOnly = new Wrapper(impl)
}
