package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters._
sealed trait RuleType {
  def unwrap: software.amazon.awssdk.services.clouddirectory.model.RuleType
}
object RuleType {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.RuleType
  ): zio.aws.clouddirectory.model.RuleType = value match {
    case software.amazon.awssdk.services.clouddirectory.model.RuleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.RuleType.BINARY_LENGTH =>
      val r = BINARY_LENGTH
      r
    case software.amazon.awssdk.services.clouddirectory.model.RuleType.NUMBER_COMPARISON =>
      val r = NUMBER_COMPARISON
      r
    case software.amazon.awssdk.services.clouddirectory.model.RuleType.STRING_FROM_SET =>
      val r = STRING_FROM_SET
      r
    case software.amazon.awssdk.services.clouddirectory.model.RuleType.STRING_LENGTH =>
      val r = STRING_LENGTH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RuleType =
      software.amazon.awssdk.services.clouddirectory.model.RuleType.UNKNOWN_TO_SDK_VERSION
  }
  case object BINARY_LENGTH extends zio.aws.clouddirectory.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RuleType =
      software.amazon.awssdk.services.clouddirectory.model.RuleType.BINARY_LENGTH
  }
  case object NUMBER_COMPARISON extends zio.aws.clouddirectory.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RuleType =
      software.amazon.awssdk.services.clouddirectory.model.RuleType.NUMBER_COMPARISON
  }
  case object STRING_FROM_SET extends zio.aws.clouddirectory.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RuleType =
      software.amazon.awssdk.services.clouddirectory.model.RuleType.STRING_FROM_SET
  }
  case object STRING_LENGTH extends zio.aws.clouddirectory.model.RuleType {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.RuleType =
      software.amazon.awssdk.services.clouddirectory.model.RuleType.STRING_LENGTH
  }
}
