package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{LinkName, ObjectIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ObjectIdentifierAndLinkNameTuple(
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent,
    linkName: Optional[LinkName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple = {
    import ObjectIdentifierAndLinkNameTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
      .builder()
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .optionallyWith(
        linkName.map(value => LinkName.unwrap(value): java.lang.String)
      )(_.linkName)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly =
    zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
      .wrap(buildAwsValue())
}
object ObjectIdentifierAndLinkNameTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple =
      zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple(
        objectIdentifier.map(value => value),
        linkName.map(value => value)
      )
    def objectIdentifier: Optional[ObjectIdentifier]
    def linkName: Optional[LinkName]
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
    def getLinkName: ZIO[Any, AwsError, LinkName] =
      AwsError.unwrapOptionField("linkName", linkName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
  ) extends zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly {
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
    override val linkName: Optional[LinkName] = zio.aws.core.internal
      .optionalFromNullable(impl.linkName())
      .map(value => zio.aws.clouddirectory.model.primitives.LinkName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectIdentifierAndLinkNameTuple
  ): zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly =
    new Wrapper(impl)
}
