package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class EnableDirectoryResponse(directoryArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse = {
    import EnableDirectoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly =
    zio.aws.clouddirectory.model.EnableDirectoryResponse.wrap(buildAwsValue())
}
object EnableDirectoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.EnableDirectoryResponse =
      zio.aws.clouddirectory.model.EnableDirectoryResponse(directoryArn)
    def directoryArn: Arn
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse
  ) extends zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.EnableDirectoryResponse
  ): zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly =
    new Wrapper(impl)
}
