package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{FacetName, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteFacetRequest(schemaArn: Arn, name: FacetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest = {
    import DeleteFacetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest
      .builder()
      .schemaArn(Arn.unwrap(schemaArn): java.lang.String)
      .name(FacetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.DeleteFacetRequest.ReadOnly =
    zio.aws.clouddirectory.model.DeleteFacetRequest.wrap(buildAwsValue())
}
object DeleteFacetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DeleteFacetRequest =
      zio.aws.clouddirectory.model.DeleteFacetRequest(schemaArn, name)
    def schemaArn: Arn
    def name: FacetName
    def getSchemaArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(schemaArn)
    def getName: ZIO[Any, Nothing, FacetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest
  ) extends zio.aws.clouddirectory.model.DeleteFacetRequest.ReadOnly {
    override val schemaArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.schemaArn())
    override val name: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DeleteFacetRequest
  ): zio.aws.clouddirectory.model.DeleteFacetRequest.ReadOnly = new Wrapper(
    impl
  )
}
