package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchDetachFromIndexResponse(
    detachedObjectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse = {
    import BatchDetachFromIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse
      .builder()
      .optionallyWith(
        detachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.detachedObjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachFromIndexResponse
      .wrap(buildAwsValue())
}
object BatchDetachFromIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachFromIndexResponse =
      zio.aws.clouddirectory.model.BatchDetachFromIndexResponse(
        detachedObjectIdentifier.map(value => value)
      )
    def detachedObjectIdentifier: Optional[ObjectIdentifier]
    def getDetachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "detachedObjectIdentifier",
        detachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse
  ) extends zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly {
    override val detachedObjectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachedObjectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse
  ): zio.aws.clouddirectory.model.BatchDetachFromIndexResponse.ReadOnly =
    new Wrapper(impl)
}
