package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFacetResponse(
    facet: Optional[zio.aws.clouddirectory.model.Facet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse = {
    import GetFacetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse
      .builder()
      .optionallyWith(facet.map(value => value.buildAwsValue()))(_.facet)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly =
    zio.aws.clouddirectory.model.GetFacetResponse.wrap(buildAwsValue())
}
object GetFacetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.GetFacetResponse =
      zio.aws.clouddirectory.model
        .GetFacetResponse(facet.map(value => value.asEditable))
    def facet: Optional[zio.aws.clouddirectory.model.Facet.ReadOnly]
    def getFacet
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.Facet.ReadOnly] =
      AwsError.unwrapOptionField("facet", facet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse
  ) extends zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly {
    override val facet: Optional[zio.aws.clouddirectory.model.Facet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facet())
        .map(value => zio.aws.clouddirectory.model.Facet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.GetFacetResponse
  ): zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly = new Wrapper(impl)
}
