package zio.aws.clouddirectory.model
import scala.jdk.CollectionConverters._
sealed trait ConsistencyLevel {
  def unwrap
      : software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel
}
object ConsistencyLevel {
  def wrap(
      value: software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel
  ): zio.aws.clouddirectory.model.ConsistencyLevel = value match {
    case software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.SERIALIZABLE =>
      val r = SERIALIZABLE
      r
    case software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.EVENTUAL =>
      val r = EVENTUAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.clouddirectory.model.ConsistencyLevel {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel =
      software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object SERIALIZABLE
      extends zio.aws.clouddirectory.model.ConsistencyLevel {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel =
      software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.SERIALIZABLE
  }
  case object EVENTUAL extends zio.aws.clouddirectory.model.ConsistencyLevel {
    override def unwrap
        : software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel =
      software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel.EVENTUAL
  }
}
