package zio.aws.clouddirectory
import zio.aws.clouddirectory.model.DetachPolicyResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.clouddirectory.model.{
  BatchWriteRequest,
  ListTypedLinkFacetNamesRequest,
  UpdateFacetRequest,
  AttachTypedLinkRequest,
  ListObjectAttributesRequest,
  AttachToIndexRequest,
  GetAppliedSchemaVersionRequest,
  GetObjectInformationRequest,
  GetDirectoryRequest,
  GetSchemaAsJsonRequest,
  ListManagedSchemaArnsRequest,
  DisableDirectoryRequest,
  CreateFacetRequest,
  ListObjectParentPathsRequest,
  CreateIndexRequest,
  DetachObjectRequest,
  LookupPolicyRequest,
  BatchReadRequest,
  ListPolicyAttachmentsRequest,
  UpdateTypedLinkFacetRequest,
  ListTagsForResourceRequest,
  CreateSchemaRequest,
  GetTypedLinkFacetInformationRequest,
  ListIndexRequest,
  UpgradeAppliedSchemaRequest,
  ListIncomingTypedLinksRequest,
  ListOutgoingTypedLinksRequest,
  UpdateObjectAttributesRequest,
  CreateDirectoryRequest,
  AddFacetToObjectRequest,
  DeleteTypedLinkFacetRequest,
  GetLinkAttributesRequest,
  ListAttachedIndicesRequest,
  ListObjectChildrenRequest,
  DeleteDirectoryRequest,
  ListObjectPoliciesRequest,
  ListPublishedSchemaArnsRequest,
  EnableDirectoryRequest,
  UpdateSchemaRequest,
  DetachTypedLinkRequest,
  CreateTypedLinkFacetRequest,
  UpgradePublishedSchemaRequest,
  PutSchemaFromJsonRequest,
  RemoveFacetFromObjectRequest,
  DetachFromIndexRequest,
  UpdateLinkAttributesRequest,
  DetachPolicyRequest,
  UntagResourceRequest,
  DeleteFacetRequest,
  ListFacetNamesRequest,
  ListDevelopmentSchemaArnsRequest,
  ListAppliedSchemaArnsRequest,
  PublishSchemaRequest,
  AttachObjectRequest,
  ListTypedLinkFacetAttributesRequest,
  ApplySchemaRequest,
  DeleteSchemaRequest,
  DeleteObjectRequest,
  CreateObjectRequest,
  ListDirectoriesRequest,
  GetObjectAttributesRequest,
  ListObjectParentsRequest,
  TagResourceRequest,
  AttachPolicyRequest,
  GetFacetRequest,
  ListFacetAttributesRequest
}
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.clouddirectory.model.primitives.{
  LinkName,
  Arn,
  TypedLinkName,
  FacetName,
  ObjectIdentifier
}
object CloudDirectoryMock extends Mock[CloudDirectory] {
  object ListObjectParentPaths
      extends Stream[
        ListObjectParentPathsRequest,
        AwsError,
        zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
      ]
  object ListObjectParentPathsPaginated
      extends Effect[
        ListObjectParentPathsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly
      ]
  object ListDirectories
      extends Stream[
        ListDirectoriesRequest,
        AwsError,
        zio.aws.clouddirectory.model.Directory.ReadOnly
      ]
  object ListDirectoriesPaginated
      extends Effect[
        ListDirectoriesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly
      ]
  object ListAttachedIndices
      extends Stream[
        ListAttachedIndicesRequest,
        AwsError,
        zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
      ]
  object ListAttachedIndicesPaginated
      extends Effect[
        ListAttachedIndicesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListAttachedIndicesResponse.ReadOnly
      ]
  object AttachToIndex
      extends Effect[
        AttachToIndexRequest,
        AwsError,
        zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly
      ]
  object ListObjectAttributes
      extends Stream[
        ListObjectAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
      ]
  object ListObjectAttributesPaginated
      extends Effect[
        ListObjectAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly
      ]
  object BatchWrite
      extends Effect[
        BatchWriteRequest,
        AwsError,
        zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly
      ]
  object DeleteFacet
      extends Effect[
        DeleteFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.DeleteFacetResponse.ReadOnly
      ]
  object AttachTypedLink
      extends Effect[
        AttachTypedLinkRequest,
        AwsError,
        zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly
      ]
  object ListFacetAttributes
      extends Stream[
        ListFacetAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
      ]
  object ListFacetAttributesPaginated
      extends Effect[
        ListFacetAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly
      ]
  object LookupPolicy
      extends Stream[
        LookupPolicyRequest,
        AwsError,
        zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
      ]
  object LookupPolicyPaginated
      extends Effect[
        LookupPolicyRequest,
        AwsError,
        zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly
      ]
  object AttachObject
      extends Effect[
        AttachObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly
      ]
  object ListObjectParents
      extends Effect[ListObjectParentsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly,
        zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
      ]]
  object ListObjectParentsPaginated
      extends Effect[
        ListObjectParentsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly
      ]
  object GetAppliedSchemaVersion
      extends Effect[
        GetAppliedSchemaVersionRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly
      ]
  object UpdateLinkAttributes
      extends Effect[
        UpdateLinkAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.ReadOnly
      ]
  object GetObjectAttributes
      extends Effect[
        GetObjectAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly
      ]
  object UpgradePublishedSchema
      extends Effect[
        UpgradePublishedSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly
      ]
  object PutSchemaFromJson
      extends Effect[
        PutSchemaFromJsonRequest,
        AwsError,
        zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly
      ]
  object ListManagedSchemaArns
      extends Stream[ListManagedSchemaArnsRequest, AwsError, Arn]
  object ListManagedSchemaArnsPaginated
      extends Effect[
        ListManagedSchemaArnsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.ReadOnly
      ]
  object EnableDirectory
      extends Effect[
        EnableDirectoryRequest,
        AwsError,
        zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly
      ]
  object DetachPolicy extends Effect[DetachPolicyRequest, AwsError, ReadOnly]
  object UpdateTypedLinkFacet
      extends Effect[
        UpdateTypedLinkFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.ReadOnly
      ]
  object DeleteTypedLinkFacet
      extends Effect[
        DeleteTypedLinkFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.ReadOnly
      ]
  object UpgradeAppliedSchema
      extends Effect[
        UpgradeAppliedSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly
      ]
  object DeleteObject
      extends Effect[
        DeleteObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.DeleteObjectResponse.ReadOnly
      ]
  object CreateTypedLinkFacet
      extends Effect[
        CreateTypedLinkFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.ReadOnly
      ]
  object UpdateFacet
      extends Effect[
        UpdateFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpdateFacetResponse.ReadOnly
      ]
  object ListObjectPolicies
      extends Stream[ListObjectPoliciesRequest, AwsError, ObjectIdentifier]
  object ListObjectPoliciesPaginated
      extends Effect[
        ListObjectPoliciesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly
      ]
  object ListTypedLinkFacetNames
      extends Stream[ListTypedLinkFacetNamesRequest, AwsError, TypedLinkName]
  object ListTypedLinkFacetNamesPaginated
      extends Effect[
        ListTypedLinkFacetNamesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly
      ]
  object RemoveFacetFromObject
      extends Effect[
        RemoveFacetFromObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.ReadOnly
      ]
  object DisableDirectory
      extends Effect[
        DisableDirectoryRequest,
        AwsError,
        zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly
      ]
  object GetFacet
      extends Effect[
        GetFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly
      ]
  object CreateObject
      extends Effect[
        CreateObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly
      ]
  object UpdateSchema
      extends Effect[
        UpdateSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpdateSchemaResponse.ReadOnly
      ]
  object GetSchemaAsJson
      extends Effect[
        GetSchemaAsJsonRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly
      ]
  object CreateFacet
      extends Effect[
        CreateFacetRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateFacetResponse.ReadOnly
      ]
  object DetachTypedLink extends Effect[DetachTypedLinkRequest, AwsError, Unit]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.clouddirectory.model.UntagResourceResponse.ReadOnly
      ]
  object ListObjectChildren
      extends Stream[
        ListObjectChildrenRequest,
        AwsError,
        Tuple2[LinkName, ObjectIdentifier]
      ]
  object ListObjectChildrenPaginated
      extends Effect[
        ListObjectChildrenRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly
      ]
  object ApplySchema
      extends Effect[
        ApplySchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly
      ]
  object ListFacetNames
      extends Stream[ListFacetNamesRequest, AwsError, FacetName]
  object ListFacetNamesPaginated
      extends Effect[
        ListFacetNamesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly
      ]
  object ListTypedLinkFacetAttributes
      extends Stream[
        ListTypedLinkFacetAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
      ]
  object ListTypedLinkFacetAttributesPaginated
      extends Effect[
        ListTypedLinkFacetAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly
      ]
  object AttachPolicy
      extends Effect[
        AttachPolicyRequest,
        AwsError,
        zio.aws.clouddirectory.model.AttachPolicyResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.clouddirectory.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly
      ]
  object UpdateObjectAttributes
      extends Effect[
        UpdateObjectAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.ReadOnly
      ]
  object AddFacetToObject
      extends Effect[
        AddFacetToObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.AddFacetToObjectResponse.ReadOnly
      ]
  object GetTypedLinkFacetInformation
      extends Effect[
        GetTypedLinkFacetInformationRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.clouddirectory.model.TagResourceResponse.ReadOnly
      ]
  object CreateDirectory
      extends Effect[
        CreateDirectoryRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly
      ]
  object GetLinkAttributes
      extends Effect[
        GetLinkAttributesRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly
      ]
  object CreateSchema
      extends Effect[
        CreateSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly
      ]
  object GetObjectInformation
      extends Effect[
        GetObjectInformationRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetObjectInformationResponse.ReadOnly
      ]
  object ListIndex
      extends Stream[
        ListIndexRequest,
        AwsError,
        zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
      ]
  object ListIndexPaginated
      extends Effect[
        ListIndexRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly
      ]
  object DetachFromIndex
      extends Effect[
        DetachFromIndexRequest,
        AwsError,
        zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly
      ]
  object PublishSchema
      extends Effect[
        PublishSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly
      ]
  object DeleteSchema
      extends Effect[
        DeleteSchemaRequest,
        AwsError,
        zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly
      ]
  object ListOutgoingTypedLinks
      extends Stream[
        ListOutgoingTypedLinksRequest,
        AwsError,
        zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
      ]
  object ListOutgoingTypedLinksPaginated
      extends Effect[
        ListOutgoingTypedLinksRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly
      ]
  object GetDirectory
      extends Effect[
        GetDirectoryRequest,
        AwsError,
        zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly
      ]
  object ListPublishedSchemaArns
      extends Stream[ListPublishedSchemaArnsRequest, AwsError, Arn]
  object ListPublishedSchemaArnsPaginated
      extends Effect[
        ListPublishedSchemaArnsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly
      ]
  object ListPolicyAttachments
      extends Stream[ListPolicyAttachmentsRequest, AwsError, ObjectIdentifier]
  object ListPolicyAttachmentsPaginated
      extends Effect[
        ListPolicyAttachmentsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly
      ]
  object DeleteDirectory
      extends Effect[
        DeleteDirectoryRequest,
        AwsError,
        zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly
      ]
  object DetachObject
      extends Effect[
        DetachObjectRequest,
        AwsError,
        zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly
      ]
  object BatchRead
      extends Effect[
        BatchReadRequest,
        AwsError,
        zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly
      ]
  object ListIncomingTypedLinks
      extends Stream[
        ListIncomingTypedLinksRequest,
        AwsError,
        zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
      ]
  object ListIncomingTypedLinksPaginated
      extends Effect[
        ListIncomingTypedLinksRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly
      ]
  object ListDevelopmentSchemaArns
      extends Stream[ListDevelopmentSchemaArnsRequest, AwsError, Arn]
  object ListDevelopmentSchemaArnsPaginated
      extends Effect[
        ListDevelopmentSchemaArnsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly
      ]
  object CreateIndex
      extends Effect[
        CreateIndexRequest,
        AwsError,
        zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly
      ]
  object ListAppliedSchemaArns
      extends Stream[ListAppliedSchemaArnsRequest, AwsError, Arn]
  object ListAppliedSchemaArnsPaginated
      extends Effect[
        ListAppliedSchemaArnsRequest,
        AwsError,
        zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, CloudDirectory] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, CloudDirectory] { rts =>
        ZIO.succeed {
          new CloudDirectory {
            val api: CloudDirectoryAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): CloudDirectory = this
            def listObjectParentPaths(
                request: ListObjectParentPathsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
            ] = rts.unsafeRun(proxy(ListObjectParentPaths, request))
            def listObjectParentPathsPaginated(
                request: ListObjectParentPathsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListObjectParentPathsResponse.ReadOnly
            ] = proxy(ListObjectParentPathsPaginated, request)
            def listDirectories(request: ListDirectoriesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.Directory.ReadOnly
            ] = rts.unsafeRun(proxy(ListDirectories, request))
            def listDirectoriesPaginated(request: ListDirectoriesRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListDirectoriesResponse.ReadOnly
            ] = proxy(ListDirectoriesPaginated, request)
            def listAttachedIndices(
                request: ListAttachedIndicesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
            ] = rts.unsafeRun(proxy(ListAttachedIndices, request))
            def listAttachedIndicesPaginated(
                request: ListAttachedIndicesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListAttachedIndicesResponse.ReadOnly
            ] = proxy(ListAttachedIndicesPaginated, request)
            def attachToIndex(request: AttachToIndexRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.AttachToIndexResponse.ReadOnly
            ] = proxy(AttachToIndex, request)
            def listObjectAttributes(
                request: ListObjectAttributesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
            ] = rts.unsafeRun(proxy(ListObjectAttributes, request))
            def listObjectAttributesPaginated(
                request: ListObjectAttributesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListObjectAttributesResponse.ReadOnly
            ] = proxy(ListObjectAttributesPaginated, request)
            def batchWrite(request: BatchWriteRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.BatchWriteResponse.ReadOnly
            ] = proxy(BatchWrite, request)
            def deleteFacet(request: DeleteFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DeleteFacetResponse.ReadOnly
            ] = proxy(DeleteFacet, request)
            def attachTypedLink(request: AttachTypedLinkRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.AttachTypedLinkResponse.ReadOnly
            ] = proxy(AttachTypedLink, request)
            def listFacetAttributes(
                request: ListFacetAttributesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
            ] = rts.unsafeRun(proxy(ListFacetAttributes, request))
            def listFacetAttributesPaginated(
                request: ListFacetAttributesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly
            ] = proxy(ListFacetAttributesPaginated, request)
            def lookupPolicy(request: LookupPolicyRequest): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.PolicyToPath.ReadOnly
            ] = rts.unsafeRun(proxy(LookupPolicy, request))
            def lookupPolicyPaginated(request: LookupPolicyRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.LookupPolicyResponse.ReadOnly
            ] = proxy(LookupPolicyPaginated, request)
            def attachObject(request: AttachObjectRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.AttachObjectResponse.ReadOnly
            ] = proxy(AttachObject, request)
            def listObjectParents(
                request: ListObjectParentsRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly,
              zio.aws.clouddirectory.model.ObjectIdentifierAndLinkNameTuple.ReadOnly
            ]] = proxy(ListObjectParents, request)
            def listObjectParentsPaginated(
                request: ListObjectParentsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListObjectParentsResponse.ReadOnly
            ] = proxy(ListObjectParentsPaginated, request)
            def getAppliedSchemaVersion(
                request: GetAppliedSchemaVersionRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetAppliedSchemaVersionResponse.ReadOnly
            ] = proxy(GetAppliedSchemaVersion, request)
            def updateLinkAttributes(request: UpdateLinkAttributesRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpdateLinkAttributesResponse.ReadOnly
            ] = proxy(UpdateLinkAttributes, request)
            def getObjectAttributes(request: GetObjectAttributesRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetObjectAttributesResponse.ReadOnly
            ] = proxy(GetObjectAttributes, request)
            def upgradePublishedSchema(
                request: UpgradePublishedSchemaRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpgradePublishedSchemaResponse.ReadOnly
            ] = proxy(UpgradePublishedSchema, request)
            def putSchemaFromJson(request: PutSchemaFromJsonRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.PutSchemaFromJsonResponse.ReadOnly
            ] = proxy(PutSchemaFromJson, request)
            def listManagedSchemaArns(
                request: ListManagedSchemaArnsRequest
            ): ZStream[Any, AwsError, Arn] =
              rts.unsafeRun(proxy(ListManagedSchemaArns, request))
            def listManagedSchemaArnsPaginated(
                request: ListManagedSchemaArnsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListManagedSchemaArnsResponse.ReadOnly
            ] = proxy(ListManagedSchemaArnsPaginated, request)
            def enableDirectory(request: EnableDirectoryRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.EnableDirectoryResponse.ReadOnly
            ] = proxy(EnableDirectory, request)
            def detachPolicy(
                request: DetachPolicyRequest
            ): IO[AwsError, ReadOnly] = proxy(DetachPolicy, request)
            def updateTypedLinkFacet(request: UpdateTypedLinkFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpdateTypedLinkFacetResponse.ReadOnly
            ] = proxy(UpdateTypedLinkFacet, request)
            def deleteTypedLinkFacet(request: DeleteTypedLinkFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DeleteTypedLinkFacetResponse.ReadOnly
            ] = proxy(DeleteTypedLinkFacet, request)
            def upgradeAppliedSchema(request: UpgradeAppliedSchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpgradeAppliedSchemaResponse.ReadOnly
            ] = proxy(UpgradeAppliedSchema, request)
            def deleteObject(request: DeleteObjectRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DeleteObjectResponse.ReadOnly
            ] = proxy(DeleteObject, request)
            def createTypedLinkFacet(request: CreateTypedLinkFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateTypedLinkFacetResponse.ReadOnly
            ] = proxy(CreateTypedLinkFacet, request)
            def updateFacet(request: UpdateFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpdateFacetResponse.ReadOnly
            ] = proxy(UpdateFacet, request)
            def listObjectPolicies(
                request: ListObjectPoliciesRequest
            ): ZStream[Any, AwsError, ObjectIdentifier] =
              rts.unsafeRun(proxy(ListObjectPolicies, request))
            def listObjectPoliciesPaginated(
                request: ListObjectPoliciesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListObjectPoliciesResponse.ReadOnly
            ] = proxy(ListObjectPoliciesPaginated, request)
            def listTypedLinkFacetNames(
                request: ListTypedLinkFacetNamesRequest
            ): ZStream[Any, AwsError, TypedLinkName] =
              rts.unsafeRun(proxy(ListTypedLinkFacetNames, request))
            def listTypedLinkFacetNamesPaginated(
                request: ListTypedLinkFacetNamesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListTypedLinkFacetNamesResponse.ReadOnly
            ] = proxy(ListTypedLinkFacetNamesPaginated, request)
            def removeFacetFromObject(
                request: RemoveFacetFromObjectRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.RemoveFacetFromObjectResponse.ReadOnly
            ] = proxy(RemoveFacetFromObject, request)
            def disableDirectory(request: DisableDirectoryRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DisableDirectoryResponse.ReadOnly
            ] = proxy(DisableDirectory, request)
            def getFacet(request: GetFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetFacetResponse.ReadOnly
            ] = proxy(GetFacet, request)
            def createObject(request: CreateObjectRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateObjectResponse.ReadOnly
            ] = proxy(CreateObject, request)
            def updateSchema(request: UpdateSchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpdateSchemaResponse.ReadOnly
            ] = proxy(UpdateSchema, request)
            def getSchemaAsJson(request: GetSchemaAsJsonRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetSchemaAsJsonResponse.ReadOnly
            ] = proxy(GetSchemaAsJson, request)
            def createFacet(request: CreateFacetRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateFacetResponse.ReadOnly
            ] = proxy(CreateFacet, request)
            def detachTypedLink(
                request: DetachTypedLinkRequest
            ): IO[AwsError, Unit] = proxy(DetachTypedLink, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def listObjectChildren(
                request: ListObjectChildrenRequest
            ): ZStream[Any, AwsError, Tuple2[LinkName, ObjectIdentifier]] =
              rts.unsafeRun(proxy(ListObjectChildren, request))
            def listObjectChildrenPaginated(
                request: ListObjectChildrenRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListObjectChildrenResponse.ReadOnly
            ] = proxy(ListObjectChildrenPaginated, request)
            def applySchema(request: ApplySchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.ApplySchemaResponse.ReadOnly
            ] = proxy(ApplySchema, request)
            def listFacetNames(
                request: ListFacetNamesRequest
            ): ZStream[Any, AwsError, FacetName] =
              rts.unsafeRun(proxy(ListFacetNames, request))
            def listFacetNamesPaginated(request: ListFacetNamesRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListFacetNamesResponse.ReadOnly
            ] = proxy(ListFacetNamesPaginated, request)
            def listTypedLinkFacetAttributes(
                request: ListTypedLinkFacetAttributesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.TypedLinkAttributeDefinition.ReadOnly
            ] = rts.unsafeRun(proxy(ListTypedLinkFacetAttributes, request))
            def listTypedLinkFacetAttributesPaginated(
                request: ListTypedLinkFacetAttributesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListTypedLinkFacetAttributesResponse.ReadOnly
            ] = proxy(ListTypedLinkFacetAttributesPaginated, request)
            def attachPolicy(request: AttachPolicyRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.AttachPolicyResponse.ReadOnly
            ] = proxy(AttachPolicy, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.Tag.ReadOnly
            ] = rts.unsafeRun(proxy(ListTagsForResource, request))
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def updateObjectAttributes(
                request: UpdateObjectAttributesRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.UpdateObjectAttributesResponse.ReadOnly
            ] = proxy(UpdateObjectAttributes, request)
            def addFacetToObject(request: AddFacetToObjectRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.AddFacetToObjectResponse.ReadOnly
            ] = proxy(AddFacetToObject, request)
            def getTypedLinkFacetInformation(
                request: GetTypedLinkFacetInformationRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetTypedLinkFacetInformationResponse.ReadOnly
            ] = proxy(GetTypedLinkFacetInformation, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def createDirectory(request: CreateDirectoryRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateDirectoryResponse.ReadOnly
            ] = proxy(CreateDirectory, request)
            def getLinkAttributes(request: GetLinkAttributesRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetLinkAttributesResponse.ReadOnly
            ] = proxy(GetLinkAttributes, request)
            def createSchema(request: CreateSchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateSchemaResponse.ReadOnly
            ] = proxy(CreateSchema, request)
            def getObjectInformation(request: GetObjectInformationRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetObjectInformationResponse.ReadOnly
            ] = proxy(GetObjectInformation, request)
            def listIndex(request: ListIndexRequest): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.IndexAttachment.ReadOnly
            ] = rts.unsafeRun(proxy(ListIndex, request))
            def listIndexPaginated(request: ListIndexRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListIndexResponse.ReadOnly
            ] = proxy(ListIndexPaginated, request)
            def detachFromIndex(request: DetachFromIndexRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly
            ] = proxy(DetachFromIndex, request)
            def publishSchema(request: PublishSchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.PublishSchemaResponse.ReadOnly
            ] = proxy(PublishSchema, request)
            def deleteSchema(request: DeleteSchemaRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DeleteSchemaResponse.ReadOnly
            ] = proxy(DeleteSchema, request)
            def listOutgoingTypedLinks(
                request: ListOutgoingTypedLinksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
            ] = rts.unsafeRun(proxy(ListOutgoingTypedLinks, request))
            def listOutgoingTypedLinksPaginated(
                request: ListOutgoingTypedLinksRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListOutgoingTypedLinksResponse.ReadOnly
            ] = proxy(ListOutgoingTypedLinksPaginated, request)
            def getDirectory(request: GetDirectoryRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.GetDirectoryResponse.ReadOnly
            ] = proxy(GetDirectory, request)
            def listPublishedSchemaArns(
                request: ListPublishedSchemaArnsRequest
            ): ZStream[Any, AwsError, Arn] =
              rts.unsafeRun(proxy(ListPublishedSchemaArns, request))
            def listPublishedSchemaArnsPaginated(
                request: ListPublishedSchemaArnsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListPublishedSchemaArnsResponse.ReadOnly
            ] = proxy(ListPublishedSchemaArnsPaginated, request)
            def listPolicyAttachments(
                request: ListPolicyAttachmentsRequest
            ): ZStream[Any, AwsError, ObjectIdentifier] =
              rts.unsafeRun(proxy(ListPolicyAttachments, request))
            def listPolicyAttachmentsPaginated(
                request: ListPolicyAttachmentsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly
            ] = proxy(ListPolicyAttachmentsPaginated, request)
            def deleteDirectory(request: DeleteDirectoryRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DeleteDirectoryResponse.ReadOnly
            ] = proxy(DeleteDirectory, request)
            def detachObject(request: DetachObjectRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.DetachObjectResponse.ReadOnly
            ] = proxy(DetachObject, request)
            def batchRead(request: BatchReadRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.BatchReadResponse.ReadOnly
            ] = proxy(BatchRead, request)
            def listIncomingTypedLinks(
                request: ListIncomingTypedLinksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
            ] = rts.unsafeRun(proxy(ListIncomingTypedLinks, request))
            def listIncomingTypedLinksPaginated(
                request: ListIncomingTypedLinksRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListIncomingTypedLinksResponse.ReadOnly
            ] = proxy(ListIncomingTypedLinksPaginated, request)
            def listDevelopmentSchemaArns(
                request: ListDevelopmentSchemaArnsRequest
            ): ZStream[Any, AwsError, Arn] =
              rts.unsafeRun(proxy(ListDevelopmentSchemaArns, request))
            def listDevelopmentSchemaArnsPaginated(
                request: ListDevelopmentSchemaArnsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListDevelopmentSchemaArnsResponse.ReadOnly
            ] = proxy(ListDevelopmentSchemaArnsPaginated, request)
            def createIndex(request: CreateIndexRequest): IO[
              AwsError,
              zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly
            ] = proxy(CreateIndex, request)
            def listAppliedSchemaArns(
                request: ListAppliedSchemaArnsRequest
            ): ZStream[Any, AwsError, Arn] =
              rts.unsafeRun(proxy(ListAppliedSchemaArns, request))
            def listAppliedSchemaArnsPaginated(
                request: ListAppliedSchemaArnsRequest
            ): IO[
              AwsError,
              zio.aws.clouddirectory.model.ListAppliedSchemaArnsResponse.ReadOnly
            ] = proxy(ListAppliedSchemaArnsPaginated, request)
          }
        }
      }
    }
  }
}
