package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetObjectInformation(
    objectReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation = {
    import BatchGetObjectInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation
      .builder()
      .objectReference(objectReference.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly =
    zio.aws.clouddirectory.model.BatchGetObjectInformation.wrap(buildAwsValue())
}
object BatchGetObjectInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchGetObjectInformation =
      zio.aws.clouddirectory.model
        .BatchGetObjectInformation(objectReference.asEditable)
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation
  ) extends zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly {
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchGetObjectInformation
  ): zio.aws.clouddirectory.model.BatchGetObjectInformation.ReadOnly =
    new Wrapper(impl)
}
