package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateIndexResponse(
    objectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse = {
    import CreateIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse
      .builder()
      .optionallyWith(
        objectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.objectIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.CreateIndexResponse.wrap(buildAwsValue())
}
object CreateIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.CreateIndexResponse =
      zio.aws.clouddirectory.model
        .CreateIndexResponse(objectIdentifier.map(value => value))
    def objectIdentifier: Optional[ObjectIdentifier]
    def getObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField("objectIdentifier", objectIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse
  ) extends zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly {
    override val objectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.CreateIndexResponse
  ): zio.aws.clouddirectory.model.CreateIndexResponse.ReadOnly = new Wrapper(
    impl
  )
}
