package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchWriteOperation(
    createObject: Optional[zio.aws.clouddirectory.model.BatchCreateObject] =
      Optional.Absent,
    attachObject: Optional[zio.aws.clouddirectory.model.BatchAttachObject] =
      Optional.Absent,
    detachObject: Optional[zio.aws.clouddirectory.model.BatchDetachObject] =
      Optional.Absent,
    updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes
    ] = Optional.Absent,
    deleteObject: Optional[zio.aws.clouddirectory.model.BatchDeleteObject] =
      Optional.Absent,
    addFacetToObject: Optional[
      zio.aws.clouddirectory.model.BatchAddFacetToObject
    ] = Optional.Absent,
    removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject
    ] = Optional.Absent,
    attachPolicy: Optional[zio.aws.clouddirectory.model.BatchAttachPolicy] =
      Optional.Absent,
    detachPolicy: Optional[zio.aws.clouddirectory.model.BatchDetachPolicy] =
      Optional.Absent,
    createIndex: Optional[zio.aws.clouddirectory.model.BatchCreateIndex] =
      Optional.Absent,
    attachToIndex: Optional[zio.aws.clouddirectory.model.BatchAttachToIndex] =
      Optional.Absent,
    detachFromIndex: Optional[
      zio.aws.clouddirectory.model.BatchDetachFromIndex
    ] = Optional.Absent,
    attachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchAttachTypedLink
    ] = Optional.Absent,
    detachTypedLink: Optional[
      zio.aws.clouddirectory.model.BatchDetachTypedLink
    ] = Optional.Absent,
    updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation = {
    import BatchWriteOperation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
      .builder()
      .optionallyWith(createObject.map(value => value.buildAwsValue()))(
        _.createObject
      )
      .optionallyWith(attachObject.map(value => value.buildAwsValue()))(
        _.attachObject
      )
      .optionallyWith(detachObject.map(value => value.buildAwsValue()))(
        _.detachObject
      )
      .optionallyWith(
        updateObjectAttributes.map(value => value.buildAwsValue())
      )(_.updateObjectAttributes)
      .optionallyWith(deleteObject.map(value => value.buildAwsValue()))(
        _.deleteObject
      )
      .optionallyWith(addFacetToObject.map(value => value.buildAwsValue()))(
        _.addFacetToObject
      )
      .optionallyWith(
        removeFacetFromObject.map(value => value.buildAwsValue())
      )(_.removeFacetFromObject)
      .optionallyWith(attachPolicy.map(value => value.buildAwsValue()))(
        _.attachPolicy
      )
      .optionallyWith(detachPolicy.map(value => value.buildAwsValue()))(
        _.detachPolicy
      )
      .optionallyWith(createIndex.map(value => value.buildAwsValue()))(
        _.createIndex
      )
      .optionallyWith(attachToIndex.map(value => value.buildAwsValue()))(
        _.attachToIndex
      )
      .optionallyWith(detachFromIndex.map(value => value.buildAwsValue()))(
        _.detachFromIndex
      )
      .optionallyWith(attachTypedLink.map(value => value.buildAwsValue()))(
        _.attachTypedLink
      )
      .optionallyWith(detachTypedLink.map(value => value.buildAwsValue()))(
        _.detachTypedLink
      )
      .optionallyWith(updateLinkAttributes.map(value => value.buildAwsValue()))(
        _.updateLinkAttributes
      )
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly =
    zio.aws.clouddirectory.model.BatchWriteOperation.wrap(buildAwsValue())
}
object BatchWriteOperation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchWriteOperation =
      zio.aws.clouddirectory.model.BatchWriteOperation(
        createObject.map(value => value.asEditable),
        attachObject.map(value => value.asEditable),
        detachObject.map(value => value.asEditable),
        updateObjectAttributes.map(value => value.asEditable),
        deleteObject.map(value => value.asEditable),
        addFacetToObject.map(value => value.asEditable),
        removeFacetFromObject.map(value => value.asEditable),
        attachPolicy.map(value => value.asEditable),
        detachPolicy.map(value => value.asEditable),
        createIndex.map(value => value.asEditable),
        attachToIndex.map(value => value.asEditable),
        detachFromIndex.map(value => value.asEditable),
        attachTypedLink.map(value => value.asEditable),
        detachTypedLink.map(value => value.asEditable),
        updateLinkAttributes.map(value => value.asEditable)
      )
    def createObject
        : Optional[zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly]
    def attachObject
        : Optional[zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly]
    def detachObject
        : Optional[zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly]
    def updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ]
    def deleteObject
        : Optional[zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly]
    def addFacetToObject
        : Optional[zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly]
    def removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ]
    def attachPolicy
        : Optional[zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly]
    def detachPolicy
        : Optional[zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly]
    def createIndex
        : Optional[zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly]
    def attachToIndex
        : Optional[zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly]
    def detachFromIndex
        : Optional[zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly]
    def attachTypedLink
        : Optional[zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly]
    def detachTypedLink
        : Optional[zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly]
    def updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ]
    def getCreateObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly
    ] = AwsError.unwrapOptionField("createObject", createObject)
    def getAttachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly
    ] = AwsError.unwrapOptionField("attachObject", attachObject)
    def getDetachObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly
    ] = AwsError.unwrapOptionField("detachObject", detachObject)
    def getUpdateObjectAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ] = AwsError.unwrapOptionField(
      "updateObjectAttributes",
      updateObjectAttributes
    )
    def getDeleteObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly
    ] = AwsError.unwrapOptionField("deleteObject", deleteObject)
    def getAddFacetToObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly
    ] = AwsError.unwrapOptionField("addFacetToObject", addFacetToObject)
    def getRemoveFacetFromObject: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ] =
      AwsError.unwrapOptionField("removeFacetFromObject", removeFacetFromObject)
    def getAttachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("attachPolicy", attachPolicy)
    def getDetachPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("detachPolicy", detachPolicy)
    def getCreateIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly
    ] = AwsError.unwrapOptionField("createIndex", createIndex)
    def getAttachToIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly
    ] = AwsError.unwrapOptionField("attachToIndex", attachToIndex)
    def getDetachFromIndex: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly
    ] = AwsError.unwrapOptionField("detachFromIndex", detachFromIndex)
    def getAttachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly
    ] = AwsError.unwrapOptionField("attachTypedLink", attachTypedLink)
    def getDetachTypedLink: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly
    ] = AwsError.unwrapOptionField("detachTypedLink", detachTypedLink)
    def getUpdateLinkAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("updateLinkAttributes", updateLinkAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ) extends zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly {
    override val createObject
        : Optional[zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchCreateObject.wrap(value)
        )
    override val attachObject
        : Optional[zio.aws.clouddirectory.model.BatchAttachObject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachObject.wrap(value)
        )
    override val detachObject
        : Optional[zio.aws.clouddirectory.model.BatchDetachObject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachObject.wrap(value)
        )
    override val updateObjectAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateObjectAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateObjectAttributes.wrap(value)
      )
    override val deleteObject
        : Optional[zio.aws.clouddirectory.model.BatchDeleteObject.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleteObject())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDeleteObject.wrap(value)
        )
    override val addFacetToObject: Optional[
      zio.aws.clouddirectory.model.BatchAddFacetToObject.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.addFacetToObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchAddFacetToObject.wrap(value)
      )
    override val removeFacetFromObject: Optional[
      zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.removeFacetFromObject())
      .map(value =>
        zio.aws.clouddirectory.model.BatchRemoveFacetFromObject.wrap(value)
      )
    override val attachPolicy
        : Optional[zio.aws.clouddirectory.model.BatchAttachPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachPolicy.wrap(value)
        )
    override val detachPolicy
        : Optional[zio.aws.clouddirectory.model.BatchDetachPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachPolicy())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachPolicy.wrap(value)
        )
    override val createIndex
        : Optional[zio.aws.clouddirectory.model.BatchCreateIndex.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createIndex())
        .map(value => zio.aws.clouddirectory.model.BatchCreateIndex.wrap(value))
    override val attachToIndex
        : Optional[zio.aws.clouddirectory.model.BatchAttachToIndex.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachToIndex())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachToIndex.wrap(value)
        )
    override val detachFromIndex
        : Optional[zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachFromIndex())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachFromIndex.wrap(value)
        )
    override val attachTypedLink
        : Optional[zio.aws.clouddirectory.model.BatchAttachTypedLink.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachTypedLink())
        .map(value =>
          zio.aws.clouddirectory.model.BatchAttachTypedLink.wrap(value)
        )
    override val detachTypedLink
        : Optional[zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachTypedLink())
        .map(value =>
          zio.aws.clouddirectory.model.BatchDetachTypedLink.wrap(value)
        )
    override val updateLinkAttributes: Optional[
      zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.updateLinkAttributes())
      .map(value =>
        zio.aws.clouddirectory.model.BatchUpdateLinkAttributes.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchWriteOperation
  ): zio.aws.clouddirectory.model.BatchWriteOperation.ReadOnly = new Wrapper(
    impl
  )
}
