package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{AttributeName, FacetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class FacetAttributeReference(
    targetFacetName: FacetName,
    targetAttributeName: AttributeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference = {
    import FacetAttributeReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference
      .builder()
      .targetFacetName(FacetName.unwrap(targetFacetName): java.lang.String)
      .targetAttributeName(
        AttributeName.unwrap(targetAttributeName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly =
    zio.aws.clouddirectory.model.FacetAttributeReference.wrap(buildAwsValue())
}
object FacetAttributeReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.FacetAttributeReference =
      zio.aws.clouddirectory.model
        .FacetAttributeReference(targetFacetName, targetAttributeName)
    def targetFacetName: FacetName
    def targetAttributeName: AttributeName
    def getTargetFacetName: ZIO[Any, Nothing, FacetName] =
      ZIO.succeed(targetFacetName)
    def getTargetAttributeName: ZIO[Any, Nothing, AttributeName] =
      ZIO.succeed(targetAttributeName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference
  ) extends zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly {
    override val targetFacetName: FacetName =
      zio.aws.clouddirectory.model.primitives.FacetName(impl.targetFacetName())
    override val targetAttributeName: AttributeName =
      zio.aws.clouddirectory.model.primitives
        .AttributeName(impl.targetAttributeName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference
  ): zio.aws.clouddirectory.model.FacetAttributeReference.ReadOnly =
    new Wrapper(impl)
}
