package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.FacetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Facet(
    name: Optional[FacetName] = Optional.Absent,
    objectType: Optional[zio.aws.clouddirectory.model.ObjectType] =
      Optional.Absent,
    facetStyle: Optional[zio.aws.clouddirectory.model.FacetStyle] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.Facet = {
    import Facet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.Facet
      .builder()
      .optionallyWith(
        name.map(value => FacetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(objectType.map(value => value.unwrap))(_.objectType)
      .optionallyWith(facetStyle.map(value => value.unwrap))(_.facetStyle)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.Facet.ReadOnly =
    zio.aws.clouddirectory.model.Facet.wrap(buildAwsValue())
}
object Facet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.Facet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.Facet =
      zio.aws.clouddirectory.model.Facet(
        name.map(value => value),
        objectType.map(value => value),
        facetStyle.map(value => value)
      )
    def name: Optional[FacetName]
    def objectType: Optional[zio.aws.clouddirectory.model.ObjectType]
    def facetStyle: Optional[zio.aws.clouddirectory.model.FacetStyle]
    def getName: ZIO[Any, AwsError, FacetName] =
      AwsError.unwrapOptionField("name", name)
    def getObjectType
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.ObjectType] =
      AwsError.unwrapOptionField("objectType", objectType)
    def getFacetStyle
        : ZIO[Any, AwsError, zio.aws.clouddirectory.model.FacetStyle] =
      AwsError.unwrapOptionField("facetStyle", facetStyle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.Facet
  ) extends zio.aws.clouddirectory.model.Facet.ReadOnly {
    override val name: Optional[FacetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.clouddirectory.model.primitives.FacetName(value))
    override val objectType: Optional[zio.aws.clouddirectory.model.ObjectType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectType())
        .map(value => zio.aws.clouddirectory.model.ObjectType.wrap(value))
    override val facetStyle: Optional[zio.aws.clouddirectory.model.FacetStyle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.facetStyle())
        .map(value => zio.aws.clouddirectory.model.FacetStyle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.Facet
  ): zio.aws.clouddirectory.model.Facet.ReadOnly = new Wrapper(impl)
}
