package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.ObjectIdentifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachFromIndexResponse(
    detachedObjectIdentifier: Optional[ObjectIdentifier] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse = {
    import DetachFromIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse
      .builder()
      .optionallyWith(
        detachedObjectIdentifier.map(value =>
          ObjectIdentifier.unwrap(value): java.lang.String
        )
      )(_.detachedObjectIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly =
    zio.aws.clouddirectory.model.DetachFromIndexResponse.wrap(buildAwsValue())
}
object DetachFromIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.DetachFromIndexResponse =
      zio.aws.clouddirectory.model
        .DetachFromIndexResponse(detachedObjectIdentifier.map(value => value))
    def detachedObjectIdentifier: Optional[ObjectIdentifier]
    def getDetachedObjectIdentifier: ZIO[Any, AwsError, ObjectIdentifier] =
      AwsError.unwrapOptionField(
        "detachedObjectIdentifier",
        detachedObjectIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse
  ) extends zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly {
    override val detachedObjectIdentifier: Optional[ObjectIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detachedObjectIdentifier())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.DetachFromIndexResponse
  ): zio.aws.clouddirectory.model.DetachFromIndexResponse.ReadOnly =
    new Wrapper(impl)
}
