package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchListObjectParentPathsResponse(
    pathToObjectIdentifiersList: Optional[
      Iterable[zio.aws.clouddirectory.model.PathToObjectIdentifiers]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse = {
    import BatchListObjectParentPathsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse
      .builder()
      .optionallyWith(
        pathToObjectIdentifiersList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pathToObjectIdentifiersList)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly =
    zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse
      .wrap(buildAwsValue())
}
object BatchListObjectParentPathsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse =
      zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse(
        pathToObjectIdentifiersList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pathToObjectIdentifiersList: Optional[
      List[zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPathToObjectIdentifiersList: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pathToObjectIdentifiersList",
      pathToObjectIdentifiersList
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse
  ) extends zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly {
    override val pathToObjectIdentifiersList: Optional[
      List[zio.aws.clouddirectory.model.PathToObjectIdentifiers.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pathToObjectIdentifiersList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.PathToObjectIdentifiers.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListObjectParentPathsResponse
  ): zio.aws.clouddirectory.model.BatchListObjectParentPathsResponse.ReadOnly =
    new Wrapper(impl)
}
