package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{BatchReferenceName, LinkName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateObject(
    schemaFacet: Iterable[zio.aws.clouddirectory.model.SchemaFacet],
    objectAttributeList: Iterable[
      zio.aws.clouddirectory.model.AttributeKeyAndValue
    ],
    parentReference: Optional[zio.aws.clouddirectory.model.ObjectReference] =
      Optional.Absent,
    linkName: Optional[LinkName] = Optional.Absent,
    batchReferenceName: Optional[BatchReferenceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject = {
    import BatchCreateObject.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject
      .builder()
      .schemaFacet(schemaFacet.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .objectAttributeList(objectAttributeList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(parentReference.map(value => value.buildAwsValue()))(
        _.parentReference
      )
      .optionallyWith(
        linkName.map(value => LinkName.unwrap(value): java.lang.String)
      )(_.linkName)
      .optionallyWith(
        batchReferenceName.map(value =>
          BatchReferenceName.unwrap(value): java.lang.String
        )
      )(_.batchReferenceName)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly =
    zio.aws.clouddirectory.model.BatchCreateObject.wrap(buildAwsValue())
}
object BatchCreateObject {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchCreateObject =
      zio.aws.clouddirectory.model.BatchCreateObject(
        schemaFacet.map { item =>
          item.asEditable
        },
        objectAttributeList.map { item =>
          item.asEditable
        },
        parentReference.map(value => value.asEditable),
        linkName.map(value => value),
        batchReferenceName.map(value => value)
      )
    def schemaFacet: List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly]
    def objectAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly]
    def parentReference
        : Optional[zio.aws.clouddirectory.model.ObjectReference.ReadOnly]
    def linkName: Optional[LinkName]
    def batchReferenceName: Optional[BatchReferenceName]
    def getSchemaFacet: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.SchemaFacet.ReadOnly
    ]] = ZIO.succeed(schemaFacet)
    def getObjectAttributeList: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly
    ]] = ZIO.succeed(objectAttributeList)
    def getParentReference: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = AwsError.unwrapOptionField("parentReference", parentReference)
    def getLinkName: ZIO[Any, AwsError, LinkName] =
      AwsError.unwrapOptionField("linkName", linkName)
    def getBatchReferenceName: ZIO[Any, AwsError, BatchReferenceName] =
      AwsError.unwrapOptionField("batchReferenceName", batchReferenceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject
  ) extends zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly {
    override val schemaFacet
        : List[zio.aws.clouddirectory.model.SchemaFacet.ReadOnly] = impl
      .schemaFacet()
      .asScala
      .map { item =>
        zio.aws.clouddirectory.model.SchemaFacet.wrap(item)
      }
      .toList
    override val objectAttributeList
        : List[zio.aws.clouddirectory.model.AttributeKeyAndValue.ReadOnly] =
      impl
        .objectAttributeList()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.AttributeKeyAndValue.wrap(item)
        }
        .toList
    override val parentReference
        : Optional[zio.aws.clouddirectory.model.ObjectReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentReference())
        .map(value => zio.aws.clouddirectory.model.ObjectReference.wrap(value))
    override val linkName: Optional[LinkName] = zio.aws.core.internal
      .optionalFromNullable(impl.linkName())
      .map(value => zio.aws.clouddirectory.model.primitives.LinkName(value))
    override val batchReferenceName: Optional[BatchReferenceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.batchReferenceName())
        .map(value =>
          zio.aws.clouddirectory.model.primitives.BatchReferenceName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject
  ): zio.aws.clouddirectory.model.BatchCreateObject.ReadOnly = new Wrapper(impl)
}
