package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateObjectAttributesRequest(
    directoryArn: Arn,
    objectReference: zio.aws.clouddirectory.model.ObjectReference,
    attributeUpdates: Iterable[
      zio.aws.clouddirectory.model.ObjectAttributeUpdate
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest = {
    import UpdateObjectAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest
      .builder()
      .directoryArn(Arn.unwrap(directoryArn): java.lang.String)
      .objectReference(objectReference.buildAwsValue())
      .attributeUpdates(attributeUpdates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.UpdateObjectAttributesRequest.ReadOnly =
    zio.aws.clouddirectory.model.UpdateObjectAttributesRequest
      .wrap(buildAwsValue())
}
object UpdateObjectAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.UpdateObjectAttributesRequest =
      zio.aws.clouddirectory.model.UpdateObjectAttributesRequest(
        directoryArn,
        objectReference.asEditable,
        attributeUpdates.map { item =>
          item.asEditable
        }
      )
    def directoryArn: Arn
    def objectReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def attributeUpdates
        : List[zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly]
    def getDirectoryArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(directoryArn)
    def getObjectReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(objectReference)
    def getAttributeUpdates: ZIO[Any, Nothing, List[
      zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly
    ]] = ZIO.succeed(attributeUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest
  ) extends zio.aws.clouddirectory.model.UpdateObjectAttributesRequest.ReadOnly {
    override val directoryArn: Arn =
      zio.aws.clouddirectory.model.primitives.Arn(impl.directoryArn())
    override val objectReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.objectReference())
    override val attributeUpdates
        : List[zio.aws.clouddirectory.model.ObjectAttributeUpdate.ReadOnly] =
      impl
        .attributeUpdates()
        .asScala
        .map { item =>
          zio.aws.clouddirectory.model.ObjectAttributeUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.UpdateObjectAttributesRequest
  ): zio.aws.clouddirectory.model.UpdateObjectAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
