package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetachFromIndex(
    indexReference: zio.aws.clouddirectory.model.ObjectReference,
    targetReference: zio.aws.clouddirectory.model.ObjectReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex = {
    import BatchDetachFromIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex
      .builder()
      .indexReference(indexReference.buildAwsValue())
      .targetReference(targetReference.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachFromIndex.wrap(buildAwsValue())
}
object BatchDetachFromIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachFromIndex =
      zio.aws.clouddirectory.model.BatchDetachFromIndex(
        indexReference.asEditable,
        targetReference.asEditable
      )
    def indexReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def targetReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def getIndexReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(indexReference)
    def getTargetReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex
  ) extends zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly {
    override val indexReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.indexReference())
    override val targetReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.targetReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex
  ): zio.aws.clouddirectory.model.BatchDetachFromIndex.ReadOnly = new Wrapper(
    impl
  )
}
