package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchDetachTypedLink(
    typedLinkSpecifier: zio.aws.clouddirectory.model.TypedLinkSpecifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink = {
    import BatchDetachTypedLink.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink
      .builder()
      .typedLinkSpecifier(typedLinkSpecifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly =
    zio.aws.clouddirectory.model.BatchDetachTypedLink.wrap(buildAwsValue())
}
object BatchDetachTypedLink {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchDetachTypedLink =
      zio.aws.clouddirectory.model
        .BatchDetachTypedLink(typedLinkSpecifier.asEditable)
    def typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    def getTypedLinkSpecifier: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly
    ] = ZIO.succeed(typedLinkSpecifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink
  ) extends zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly {
    override val typedLinkSpecifier
        : zio.aws.clouddirectory.model.TypedLinkSpecifier.ReadOnly =
      zio.aws.clouddirectory.model.TypedLinkSpecifier
        .wrap(impl.typedLinkSpecifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink
  ): zio.aws.clouddirectory.model.BatchDetachTypedLink.ReadOnly = new Wrapper(
    impl
  )
}
