package zio.aws.clouddirectory.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ObjectAttributeRange(
    attributeKey: Optional[zio.aws.clouddirectory.model.AttributeKey] =
      Optional.Absent,
    range: Optional[zio.aws.clouddirectory.model.TypedAttributeValueRange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange = {
    import ObjectAttributeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
      .builder()
      .optionallyWith(attributeKey.map(value => value.buildAwsValue()))(
        _.attributeKey
      )
      .optionallyWith(range.map(value => value.buildAwsValue()))(_.range)
      .build()
  }
  def asReadOnly: zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly =
    zio.aws.clouddirectory.model.ObjectAttributeRange.wrap(buildAwsValue())
}
object ObjectAttributeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ObjectAttributeRange =
      zio.aws.clouddirectory.model.ObjectAttributeRange(
        attributeKey.map(value => value.asEditable),
        range.map(value => value.asEditable)
      )
    def attributeKey
        : Optional[zio.aws.clouddirectory.model.AttributeKey.ReadOnly]
    def range: Optional[
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ]
    def getAttributeKey: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.AttributeKey.ReadOnly
    ] = AwsError.unwrapOptionField("attributeKey", attributeKey)
    def getRange: ZIO[
      Any,
      AwsError,
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ] = AwsError.unwrapOptionField("range", range)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ) extends zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly {
    override val attributeKey
        : Optional[zio.aws.clouddirectory.model.AttributeKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributeKey())
        .map(value => zio.aws.clouddirectory.model.AttributeKey.wrap(value))
    override val range: Optional[
      zio.aws.clouddirectory.model.TypedAttributeValueRange.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.range())
      .map(value =>
        zio.aws.clouddirectory.model.TypedAttributeValueRange.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange
  ): zio.aws.clouddirectory.model.ObjectAttributeRange.ReadOnly = new Wrapper(
    impl
  )
}
