package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFacetAttributesResponse(
    attributes: Optional[
      Iterable[zio.aws.clouddirectory.model.FacetAttribute]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse = {
    import ListFacetAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListFacetAttributesResponse
      .wrap(buildAwsValue())
}
object ListFacetAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListFacetAttributesResponse =
      zio.aws.clouddirectory.model.ListFacetAttributesResponse(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attributes
        : Optional[List[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.clouddirectory.model.FacetAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse
  ) extends zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly {
    override val attributes
        : Optional[List[zio.aws.clouddirectory.model.FacetAttribute.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.clouddirectory.model.FacetAttribute.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListFacetAttributesResponse
  ): zio.aws.clouddirectory.model.ListFacetAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
