package zio.aws.clouddirectory.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.clouddirectory.model.primitives.{NumberResults, NextToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BatchListAttachedIndices(
    targetReference: zio.aws.clouddirectory.model.ObjectReference,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[NumberResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices = {
    import BatchListAttachedIndices.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices
      .builder()
      .targetReference(targetReference.buildAwsValue())
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => NumberResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly =
    zio.aws.clouddirectory.model.BatchListAttachedIndices.wrap(buildAwsValue())
}
object BatchListAttachedIndices {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.BatchListAttachedIndices =
      zio.aws.clouddirectory.model.BatchListAttachedIndices(
        targetReference.asEditable,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def targetReference: zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    def nextToken: Optional[NextToken]
    def maxResults: Optional[NumberResults]
    def getTargetReference: ZIO[
      Any,
      Nothing,
      zio.aws.clouddirectory.model.ObjectReference.ReadOnly
    ] = ZIO.succeed(targetReference)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, NumberResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices
  ) extends zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly {
    override val targetReference
        : zio.aws.clouddirectory.model.ObjectReference.ReadOnly =
      zio.aws.clouddirectory.model.ObjectReference.wrap(impl.targetReference())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
    override val maxResults: Optional[NumberResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.clouddirectory.model.primitives.NumberResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.BatchListAttachedIndices
  ): zio.aws.clouddirectory.model.BatchListAttachedIndices.ReadOnly =
    new Wrapper(impl)
}
