package zio.aws.clouddirectory.model
import zio.aws.clouddirectory.model.primitives.{NextToken, ObjectIdentifier}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPolicyAttachmentsResponse(
    objectIdentifiers: Option[Iterable[ObjectIdentifier]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse = {
    import ListPolicyAttachmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse
      .builder()
      .optionallyWith(
        objectIdentifiers.map(value =>
          value.map { item =>
            ObjectIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.objectIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly =
    zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse
      .wrap(buildAwsValue())
}
object ListPolicyAttachmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse =
      zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse(
        objectIdentifiers.map(value => value),
        nextToken.map(value => value)
      )
    def objectIdentifiers: Option[List[ObjectIdentifier]]
    def nextToken: Option[NextToken]
    def getObjectIdentifiers: ZIO[Any, AwsError, List[ObjectIdentifier]] =
      AwsError.unwrapOptionField("objectIdentifiers", objectIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse
  ) extends zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly {
    override val objectIdentifiers: Option[List[ObjectIdentifier]] = scala
      .Option(impl.objectIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.clouddirectory.model.primitives.ObjectIdentifier(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.clouddirectory.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.clouddirectory.model.ListPolicyAttachmentsResponse
  ): zio.aws.clouddirectory.model.ListPolicyAttachmentsResponse.ReadOnly =
    new Wrapper(impl)
}
